<?php

namespace Mnv\Core;

use Mnv\Core\Database\Database;

/**
 * Class DB
 * @package Mnv\Core
 */
final class DB
{
    /** @var null $instance */
    private static $instance = null;

    /** @var Database  */
    private $_handle = null;

    /** @return DB|null */
    public static function init(): ?DB
    {
        if ( self::$instance == null )
            self::$instance = new DB();

        return self::$instance;
    }

    /** DB constructor. */
    private function __construct()
    {
        $databaseConfig = include GLOBAL_ROOT .'/includes/config.inc.php';
        $this->_handle = new Database($databaseConfig);
    }

    /**  @return Database  */
    public function connect(): Database
    {
        return $this->_handle;
    }

    public function __clone()
    {
        throw new \LogicException('The DB helper cannot be cloned');
    }

    public function __wakeup()
    {
        throw new \LogicException('The DB helper cannot be serialised');
    }

}