<?php

namespace Mnv\Core;

use Mnv\Core\Test\Logger;
use Mnv\Core\Managers\Role;
use Mnv\Core\Managers\AdminAuth;
use Mnv\Core\Managers\Exceptions\UnknownIdException;

use Mnv\Models\Comments;
use Mnv\Models\Exceptions\InvalidEmailException;
use Smarty;

/**
 * Class AdminMnv
 */
abstract class AdminMnv extends Mnv
{
    /** @var Logger $logger */
    protected $logger;

    /** @var Managers $managers */
    protected $managers;

    /** Mnv constructor. */
    public function __construct()
    {
        global $LANGUAGES;

        parent::__construct();

        $this->logger   = Logger::getInstance();
        $authAdmin      = new AdminAuth(UserInfo::get_ip(),true, 60 * 5);

        if ($authAdmin->check()) {
            try {
                if (!$authAdmin->admin()->doesUserHaveRole($authAdmin->getUserId(), Role::CONSUMER) || !$authAdmin->admin()->doesUserHaveRole($authAdmin->getUserId(), Role::SUBSCRIBER)) {

                    $this->managers = new Managers($authAdmin->getUserId());
                    $this->managers->getAdminManager();
                    $this->managers->manager->accessLevelName = lang('managers:accessRole:' . $this->managers->manager->accessLevel);
                    $this->smarty->assign('adminManager', $this->managers);
                    $this->smarty->assign('menu', $this->managers->getMenu());

                    /** получить количество ожидающих комментариев и сами комментарии для   */
                    if ($this->config['comments_enabled']) {
                        $pendingComments = new Comments();
                        if (isset($this->managers->manager->accessLevel) && ($this->managers->manager->accessLevel == Role::ADMIN || $this->managers->manager->accessLevel == Role::DEVELOPER)) {
                            $totalPendingComments = $pendingComments->totalPendingComments();
                            $comments = $pendingComments->getPendingComments();
                        } elseif (isset($this->managers->manager->accessLevel) && ($this->managers->manager->accessLevel == Role::MODERATOR && $this->config['comments_editors_may_approve'])) {
                            $totalPendingComments = $pendingComments->totalPendingComments();
                        }
                        $this->smarty->assign('totalPendingComments', empty($totalPendingComments) ? 0 : $totalPendingComments);
                        $this->smarty->assign('comments', empty($comments) ? 0 : $comments);
                    }

                    /** определение языка по умолчанию */
                    if (!is_null($LANGUAGES)) {
                        foreach ($LANGUAGES as $codename => $tmpLang) {
                            $LANGUAGES[$codename] = $tmpLang;
                            $LANGUAGES[$codename]->languageTransName = lang('languageList:'.$codename);
                            if ($tmpLang->isDefault) $this->smarty->assign('DEFAULT_LANG', $codename);
                        }
                    }

                } else {

                    $this->smarty->assign('errors', 'The specified user is not an administrator');
                }
            } catch (UnknownIdException $e) {
                $this->smarty->assign('Unknown', 'Unknown user ID');
                $authAdmin->logOut();
            }
        } else {
            $authAdmin->logOut();
        }

        if ((!$authAdmin->isLoggedIn()) || ($authAdmin->hasRole(Role::SUBSCRIBER) || $authAdmin ->hasRole(Role::CONSUMER))) {
            redirect('index.php?mod=auth');
        }

        /** Максимальный размер загружаемого файла */
        $this->smarty->assign('upload_max_filesize',  $this->upload_max_filesize());
        /** statuses */
        $this->smarty->assign('statuses',  lang('general:statuses'));

    }

    /**
     * Validates an email address
     *
     * @param string $email the email address to validate
     * @return string the sanitized email address
     * @throws InvalidEmailException if the email address has been invalid
     */
    protected static function validateEmailAddress(string $email): string
    {
        if (empty($email)) {
            throw new InvalidEmailException();
        }

        $email = \trim($email);

        if (!\filter_var($email, \FILTER_VALIDATE_EMAIL)) {
            throw new InvalidEmailException();
        }

        return $email;
    }

    protected function upload_max_filesize()
    {
        $max_upload = str_replace( array ('M', 'm' ), '', @ini_get( 'upload_max_filesize' ) );
        return formatsize( $max_upload * 1024 * 1024 );
    }

}