<div class="page-header page-header-light">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Статистика</span> - {$title}</h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="d-flex justify-content-center">

            </div>
        </div>
    </div>


    <div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
        <div class="d-flex">
            <div class="breadcrumb">
                <a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                <a href="index.php?mod=overview" class="breadcrumb-item">{$title}</a>
            </div>

            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="breadcrumb justify-content-center">

            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header header-elements-inline">
                    <h5 class="card-title">{$title}</h5>
                    <div class="header-elements">
                        <div class="list-icons">
                            <a class="list-icons-item" data-action="collapse"></a>
                        </div>
                    </div>
                </div>
                <div class="card-body d-flex">
                    {include file="stats.form.type-selector.tpl" action="index.php?mod=visitors"}
                    {include file="stats.form.date-selector.tpl"}
                </div>
                <table class="table table-bordered table-xs table-striped table-actions">
                    <thead>
                        <tr>
                            <th class="text-center">{stats:firstVisit}</th>
                            <th class="text-center">{stats:referer}</th>
                            <th class="text-center">{stats:visits}</th>
                        </tr>
                    </thead>
                    {if isset($visitors) && !empty($visitors)}
                        <tbody>
                            {foreach item=visitor from=$visitors}
                                <tr class="">
                                    <td nowrap="nowrap">{$visitor->firstVisitOn}</td>
                                    <td class="" width="100%">
                                        {if isset($visitor->refererWebsite)}
                                            <a href="{$visitor->referer}" target="_blank">{$visitor->refererWebsite|truncate:30}</a>
                                            {if isset($visitor->searchPhrase)} ({$visitor->searchPhrase|truncate:50}){/if}
                                        {elseif isset($visitor->refererUrl)}
                                            <a href="{$visitor->refererUrl}" target="_blank">{$visitor->refererUrl|truncate:80}</a>
                                        {/if}
                                    </td>
                                    <td class="text-center">
                                        <a href="index.php?mod=visitor&visitorId={$visitor->visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}">{$visitor->totalVisits}</a>
                                    </td>

                                </tr>
                            {/foreach}
                        </tbody>
                        {if isset($pageNums) && $pageNums > 0}
                        <tfoot>
                            <tr>
                                <td colspan="8">
                                    <div class="">{general:results}</div>
                                    {if isset($pageNums.pages)}
                                        <ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
                                            <li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">
                                                <a class="page-link" href="index.php?mod=visitors&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}">←</a>
                                            </li>
                                            {foreach from=$pageNums.pages item=number}
                                                {if $number eq $page}
                                                    <li  class="page-item active"><a class="page-link" href="index.php?mod=visitors&page={$number}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}" class="pageNum">{$number}</a></li>
                                                {elseif $number eq '...'}
                                                    <li class="page-item"><a class="page-link">...</a></li>
                                                {else}
                                                    <li class="page-item"><a class="page-link" href="index.php?mod=visitors&page={$number}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}" class="pageNum">{$number}</a></li>
                                                {/if}
                                            {/foreach}

                                            <li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">
                                                <a  class="page-link" href="index.php?mod=visitors&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}" >→</a>
                                            </li>
                                        </ul>
                                    {/if}
                                </td>
                            </tr>
                        </tfoot>
                        {/if}
                        {else}
                            <tbody><tr class="odd"><td class="data none" colspan="4" align="center">- {general:none} -</td></tr></tbody>
                        {/if}

                </table>
            </div>
        </div>
    </div>
</div>
<!-- /content area -->