<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Статистика</span> - {$title}</h4>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">

			</div>
		</div>
	</div>


	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=overview" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>

		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">

			</div>
		</div>
	</div>
</div>

<div class="content">

	<div class="card">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">Период</h5>
		</div>
		<div class="card-body d-flex">
			{include file="stats.form.date-selector.tpl"}
		</div>
	</div>
	<div class="card">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">{stats:errorInfo}</h5>
		</div>
		<table class="table table-bordered table-striped table-actions">
			<tbody>
			<tr>
				<td class="" width="200" nowrap="nowrap">{stats:requestUri}:</td>
				<td class="">
					{if isset($requestUri)}
					<a href="{$requestUri|urldecode|escape}" target="_blank">{$requestUri|urldecode|escape}</a>
					{/if}
				</td>
			</tr>
			</tbody>
		</table>
	</div>
	<div class="card">
		<div class="card-header header-elements-inline">
			<h5 class="card-title">{stats:referer}</h5>
			<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
		</div>
		<table class="table table-bordered table-striped table-actions">
			<thead>
			<tr>
				<th style="min-width:120px;">{stats:referer}</th>
				<th style="min-width:100px;">{general:date}</th>
				<th class="text-center">{stats:visitorId}</th>
			</tr>
			</thead>

			{if isset($visits) && !empty($visits)}
			<tbody>
				{foreach item=visit from=$visits name=visits}
					<tr id="visit-{$visit->visitId}">
						<td class="" width="100%">{if $visit->referer}<a href="{$visit->referer}" target="_blank">{$visit->referer|truncate:80}</a>{else}{stats:unknown}{/if}</td>
						<td class="" nowrap="nowrap">{$visit->visitDate}</td>
						<td class="text-center"><a href="index.php?mod=visitor&visitorId={$visit->visitorId}">{$visit->visitorId}</a></td>

					</tr>
				{/foreach}
			</tbody>

			{if isset($pageNums) && $pageNums > 0}
				<tfoot>
				<tr>
					<td colspan="8">
						<div class="">{general:results}</div>
                        {if isset($pageNums.pages)}
							<ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
								<li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">
									<a class="page-link legitRipple" href="index.php?mod=error&requestUri={$requestUri}&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}">←</a>
								</li>
                                {foreach from=$pageNums.pages item=number}
                                    {if $number eq $page}
										<li class="page-item active"><a class="page-link legitRipple" href="index.php?mod=error&requestUri={$requestUri}&page={$number}">{$number}</a></li>
                                    {elseif $number eq '...'}
										...
                                    {else}
										<li class="page-item"><a class="page-link legitRipple" href="index.php?mod=error&requestUri={$requestUri}&page={$number}">{$number}</a></li>
                                    {/if}
                                {/foreach}

								<li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">
									<a  class="page-link legitRipple" href="index.php?mod=error&requestUri={$requestUri}&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}" >→</a>
								</li>
							</ul>
                        {/if}
					</td>
				</tr>
				</tfoot>

			{/if}
			{else}
				<tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
			{/if}
		</table>
	</div>




</div>
<!-- /content area -->