<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=sections" class="breadcrumb-item">{$title} </a>
                {if isset($parent)}
                    <a class="breadcrumb-item" href="index.php?mod=sections"><i class="icon-clippy"></i> {sections:upToRoot}</a>
                    {if isset($parent->parentId)}
                        <a class="breadcrumb-item" href="index.php?mod=sections&parentId={$parent->parentId}">{if isset($parent->name)}<i class="icon-clippy"></i> {$parent->name}{/if}</a>
                    {/if}
                {/if}
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item" href="index.php?mod=section&action=add{if isset($page)}&page={$page}{/if}{if isset($parentId)}&parentId={$parentId}{/if}"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>

<div class="content">
    <div class="row">
    	<div class="col-md-12">
            <div class="card">

            {if isset($action) && $action == 'confirmDelete'}
                <form action="index.php?mod=sections" method="post" id="confirmDelete">
                    <div class="card-header"><h6 class="card-title">{sections:deleting}</h6></div>
                    <div class="card-body">
                        <input type="hidden" name="section[sectionId]" value="{if isset($section->sectionId)}{$section->sectionId}{/if}" />
                        <input type="hidden" name="parentId" value="{if isset($parentId)}{$parentId}{/if}" />
                        {if isset($section->hasSubsections) || isset($section->hasArticles)}
                            {if isset($articleOptions)}
                                <div class="form-group">
                                    <label class="form-group-float-label is-visible">{articles:title}</label>
                                    {html_options options=$articleOptions name="param[moveArticlesTo]" class="form-control select"}
                                </div>
                            {/if}
                            {if isset($subsectionOptions)}
                                <div class="form-group">
                                    <label class="form-group-float-label is-visible">{sections:subsectionsAndArticles}</label>
                                    {html_options options=$subsectionOptions name="param[moveSubsectionsTo]" class="form-control select"}
                                </div>
                                {/if}
                            {/if}

                            {sections:deleteSectionQuestion}?
                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <button class="btn btn-sm btn-primary" type="submit" name="action" value="deleteConfirmed">{general:yes}</button>
                        <a class="btn btn-sm btn-light" href="index.php?mod=sections{if isset($parentId)}&parentId={$parentId}{/if}">{general:cancel}</a>
                    </div>
                </form>
            {else}

                <table class="table table-togglable table-xs table-striped table-hover" id="sections">
                    <thead>
                        <tr>
	                        <th data-hide="phone, tablet" class="text-center" width="30">#</th>
                            <th data-hide="phone, tablet" class="text-center" width="50">{general:table:id}</th>
                            <th data-toggle="true" class="">{general:table:name}</th>
                            <th data-hide="phone, tablet">{general:table:alias}</th>
                            <th data-hide="phone, tablet">{general:table:path}</th>
                            <th data-hide="phone, tablet"  width="150">{general:table:type}</th>
                            <th data-hide="phone, tablet"  width="150">{general:table:typeContent}</th>
                            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($sections)}
                        <tbody class="selectable-demo-list sections_list" id="section_list">
                        {foreach item=section from=$sections name=sections}
                            <tr id="section-{$section->sectionId}" data-id="{$section->sectionId}" class="{if $section->status eq 'hidden'}opacity7{/if}">
	                            <td class="move_zone" nowrap="nowrap"><i class="icon-menu8" style="opacity: 0.5"></i> </td>
                                <td class="move_zone" nowrap="nowrap">{$section->sectionId} {*- {$section->sortOrder*}</td>
                                <td  nowrap="nowrap">
                                    {if isset($section->hasSubsections)}
                                        <a href="index.php?mod=sections&parentId={$section->sectionId}" style="border-bottom: 1px dashed;">{$section->name|strip_tags|truncate:25}</a>
                                    {else}
                                        {$section->name|strip_tags|truncate:25}
                                    {/if}
                                </td>
                                <td  nowrap="nowrap">{$section->alias|strip_tags|truncate:25}</td>
                                <td nowrap="nowrap"><a href="{$section->url}" target="_blank">{if $section->fileName eq 'index'}/{else}/{$section->fileName}/{/if}</a></td>
                                <td class="" nowrap="nowrap">{$section->typeName}</td>
                                <td class="" nowrap="nowrap">{$section->typeContentName}</td>
                                <td class="text-center">
                                    <div class="list-icons">
                                        <div class="list-icons-item dropdown">
                                            <a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="{$section->url}" target="_blank" class="dropdown-item"><i class="icon-rotate-ccw2"></i> {general:view}</a>
                                                <a class="dropdown-item" href="index.php?mod=section&action=edit&sectionId={$section->sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}"><i class="icon-pencil7"></i> {general:edit}</a>
                                                <a href="javascript:void('');" class="dropdown-item ajax_action {if $section->status eq 'visible'}active_class{/if}" data-module="sections" data-action="status" data-id="{$section->sectionId}" name="status" value="1"><i class="{if $section->status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
                                                {if $section->fileName ne 'index'}
                                                    <div class="dropdown-divider"></div>
                                                    <a href="index.php?mod=sections&action=confirmDelete&sectionId={$section->sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}" class="dropdown-item"><i class="icon-cross2"></i> {general:delete}</a>
                                                {/if}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}


                        </tbody>
                        {if isset($pageNums) && $pageNums > 0}
                        <tfoot>
                            <tr>
                                <td colspan="8">
                                    <div class="">{general:results}</div>
                                    {if isset($pageNums.pages)}
                                        <ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
                                            <li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">
                                                <a class="page-link legitRipple" href="index.php?mod=sections&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}{if $parentId}&parentId={$parentId}{/if}">←</a>
                                            </li>
                                            {foreach from=$pageNums.pages item=number}
                                                {if $number eq $page}
                                                    <li class="page-item active"><a class="page-link legitRipple" href="index.php?mod=sections&page={$number}{if $parentId}&parentId={$parentId}{/if}">{$number}</a></li>
                                                {elseif $number eq '...'}
                                                    ...
                                                {else}
                                                    <li class="page-item"><a class="page-link legitRipple" href="index.php?mod=sections&page={$number}{if $parentId}&parentId={$parentId}{/if}">{$number}</a></li>
                                                {/if}
                                            {/foreach}
                                            <li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">
                                                <a  class="page-link legitRipple" href="index.php?mod=sections&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}{if $parentId}&parentId={$parentId}{/if}" >→</a>
                                            </li>
                                        </ul>
                                    {/if}
                                </td>
                            </tr>
                        </tfoot>
                        {/if}
                    {else}
                        <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
            {/if}

            </div>
    	</div>
    </div>
</div>


<script>

    $(document).ready(function () {

        {if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show();{/if}
        {if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show(); {/if}

    });

    function moveUpMessage(){ new Noty({ text: '{sections:messages:3}', type: 'warning' }).show(); }
    function moveDownMessage(){ new Noty({ text: '{sections:messages:4}', layout: 'topRight', type: 'warning' }).show(); }
    function topMenuMessage(){ new Noty({ text: '{sections:messages:6}', type: 'warning' }).show(); }
    function downMenuMessage(){ new Noty({ text: '{sections:messages:7}', type: 'warning' }).show(); }
    function sectionVisibleMessage(){ new Noty({ text: '{sections:messages:8}', type: 'warning' }).show(); }
    function sectionHiddenMessage(){ new Noty({ text: '{sections:messages:9}', type: 'warning' }).show(); }


    $("#section_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.sections_list',
        placeholder: "ui-sortable-handle",
        update	   : function(event, ui) {
		    var sectionIds = new Array();

            $('#section_list tr').each(function() {
                sectionIds.push($(this).attr("data-id"));
		    });

            // console.log(sectionIds);
            $.ajax({
			    url:"index.php?mod=sections&action=reorder",
                method:"POST",
                data:{ sectionIds: sectionIds },
                success:function(data) {
                    location.reload();
				    //alert(data);
			    }
		    });
	    }
    }).disableSelection();

</script>



