<!-- Page header -->
<div class="page-header page-header-light">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="d-flex justify-content-center">
                <a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
            </div>
        </div>
    </div>

    <div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
        <div class="d-flex">
            <div class="breadcrumb">
                <a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                <a href="index.php?mod=payments" class="breadcrumb-item">{$title}</a>
            </div>

            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>

        <div class="header-elements d-none">
            <div class="breadcrumb justify-content-center">

                <a class="breadcrumb-elements-item" href="index.php?mod=payment&action=add" title="{general:add}"><i class="icon-plus3"></i> {general:add}</a>
            </div>
        </div>
    </div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">

    <div class="row">
        <div class="col-md-12">

            <div class="card">
                <table class="table table-togglable table-xs table-striped table-hover" id="payments">
                    <thead>
                    <tr>
                        <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
                        <th data-toggle="true">ЛОГОТИП</th>
	                    <th data-toggle="true">{general:product}</th>
                        <th data-hide="phone" class="text-center">{general:status}</th>
                        <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                    </tr>
                    </thead>
                    {if isset($payments)}
                        <tbody class="selectable-demo-list payment_list" id="payment_list">

                        {foreach item=payment from=$payments name=payments}
                            <tr id="payment-{$payment->paymentId}" data-id="{$payment->paymentId}">
                                <td class="move_zone" nowrap="nowrap">{$payment->paymentId}</td>
                                <td>{image_file_name_exists filePath="/app/Modules/Payment/{$payment->fileName}/logo.png" style="width: 105px"}</td>
                                <td><b>{$payment->name}</b></td>
                                <td class="text-center">{$payment->statusName}</td>
                                <td class="text-center">
                                    <div class="list-icons">
                                        <div class="list-icons-item dropdown">
                                            <a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a class="dropdown-item" href="index.php?mod=payment&action=edit&id={$payment->paymentId}"><i class="icon-pencil7"></i> {general:edit}</a>
                                                <a href="#" class="dropdown-item ajax_action {if $payment->status eq 'visible'}active_class{/if}" data-module="payments" data-action="status" data-id="{$payment->paymentId}" name="status" value="1" ><i class="{if $payment->status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#" class="dropdown-item" onclick="remove({$payment->paymentId}, '{$payment->name|escape}', 'payments');"><i class="icon-cross2"></i> {general:delete}</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}

                        </tbody>
                        {if isset($pageNums) && $pageNums > 0}
                        <tfoot>
                            <tr>
                                <td colspan="8">
                                    <div class="">{general:results}</div>
                                    {if isset($pageNums.pages)}
                                        <ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
                                            <li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">
                                                <a class="page-link legitRipple" href="index.php?mod=payments&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}">←</a>
                                            </li>
                                            {foreach from=$pageNums.pages item=number}
                                                {if $number eq $page}
                                                    <li class="page-item active"><a class="page-link legitRipple" href="index.php?mod=payments&page={$number}">{$number}</a></li>
                                                {elseif $number eq '...'}
                                                    ...
                                                {else}
                                                    <li class="page-item"><a class="page-link legitRipple" href="index.php?mod=payments&page={$number}">{$number}</a></li>
                                                {/if}
                                            {/foreach}

                                            <li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">
                                                <a  class="page-link legitRipple" href="index.php?mod=payments&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}" >→</a>
                                            </li>
                                        </ul>
                                    {/if}
                                </td>
                            </tr>
                        </tfoot>
                        {/if}
                    {else}
                        <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>


            </div>




        </div>

    </div>
</div>

<script>
    $(document).ready(function () {

        {if isset($errors.access_denied)} new Noty({ text: '{payments:errors:access_denied}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.name)} new Noty({ text: '{payments:errors:name}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{payments:errors:fileNameExists}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{payments:errors:not_saved}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.payment_not_found)} new Noty({ text: '{payments:errors:payment_not_found}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{payments:messages:payment_save}', type: 'success', timeout: 1500 }).show() {/if}

    });
    function deleteError(){
        new Noty({ text: '{payments:errors:payment_not_delete}', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: '{payments:messages:payment_delete}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'payment');
    }


</script>



