{assign var=wrapper value="" scope=global}
{if isset($order)}
<div class="modal-content">
    <div class="modal-header">
        <h5 class="modal-title">Заказ #{$order->id}</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
    </div>

    <div class="card-body">
        <div class="row">
            <div class="col-sm-6">
                <div class="mb-4">
                    <img src="/uploads/logo.png" class="mb-3 mt-2" alt="" style="width: 120px;">
                    <ul class="list list-unstyled mb-0">
                        <li>{$order->client->fullName}</li>
                        <li>{$order->client->contact}</li>
{*                        <li><a href="mailto:{$order->userEmail}">{$order->userEmail}</a></li>*}
                    </ul>
                </div>
            </div>

            <div class="col-sm-6">
                <div class="mb-4">
                    <div class="text-sm-right">
                        <h4 class="text-primary mb-2 mt-md-2">Заказ #{$order->id}</h4>
                        <ul class="list list-unstyled mb-0">
                            <li>Дата: <span class="font-weight-semibold">{$order->createdBy}</span></li>
{*                            <li>Due date: <span class="font-weight-semibold">May 12, 2015</span></li>*}
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-md-flex flex-md-wrap">
            <div class="mb-4 mb-md-2">
                <span class="text-muted">Продавец:</span>
                <ul class="list list-unstyled mb-0">
                    <li><h5 class="my-2">{$config.company_name}</h5></li>
                    <li><span class="font-weight-semibold">{$config.company_name}</span></li>
                    <li>{$config.address}</li>
                    <li>{$config.phone}</li>
                    <li><a href="mailto:{$config.email}">{$config.email}</a></li>
                </ul>
            </div>

            <div class="mb-2 ml-auto">
                <span class="text-muted">Детали оплаты:</span>
                <div class="d-flex flex-wrap wmin-md-400">
                    <ul class="list list-unstyled mb-0">
                        <li><h5 class="my-2">Общая сумма:</h5></li>
	                    <li>Ф.И.О:</li>
	                    <li>Телефон:</li>
	                    <li>Адрес:</li>
	                    <li>Дата:</li>
                    </ul>

                    <ul class="list list-unstyled text-right mb-0 ml-auto">
	                    <li><h5 class="font-weight-semibold my-2">{$order->amount|number_format:0:".":" "} сум</h5></li>
	                    <li><span class="font-weight-semibold">{$order->client->fullName}</span></li>
	                    <li>{if !empty($order->client->contact)}{$order->client->contact}{else} не указан{/if}</li>
	                    <li>{if !empty($order->client->address)}{$order->client->address}{else} не указан{/if}</li>
	                    <li><span class="font-weight-semibold">{$order->createdBy}</span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-lg">
            <thead>
            <tr>
                <th>Картинка</th>
                <th>Наименование</th>
                <th>Вариант товара</th>
                <th>Цена</th>
                <th>Кол-во</th>
                <th>Всего</th>
            </tr>
            </thead>
            <tbody>
            {foreach from=$order->products item=product}
            <tr>
	            <td><img src="{$product->image}" style="width: 100px"></td>
	            <td>{$product->title}</td>
	            <td>{$product->variantName}</td>
	            <td class="text-center">{$product->price|number_format:2:".":" "} сум.</td>
	            <td class="text-center">{$product->quantity}</td>
	            <td class="text-center">{$product->amount|number_format:2:".":" "} сум.</td>
            </tr>
            {/foreach}

            </tbody>
        </table>
    </div>

    <div class="card-body">
        <div class="d-md-flex flex-md-wrap">
            <div class="pt-2 mb-3">
                <h6 class="mb-3">Комментарий к заказу</h6>
                <div class="mb-3">
                    <img src="/uploads/signature.png" width="150" alt="">
                </div>

	            <p>{$order->message nofilter}</p>
            </div>

            <div class="pt-2 mb-3 wmin-md-400 ml-auto">
                <h6 class="mb-3">Total due</h6>
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                        <tr>
	                        <th>Сумма к оплате:</th>
	                        <td class="text-right">{if $order->amount ne 0}{$order->amount|number_format:0:".":" "} сум.{/if}</td>
                        </tr>
                        <tr>
	                        <th>Кол-во:</th>
	                        <td class="text-right">{$order->quantity} шт.</td>
                        </tr>
                        <tr>
	                        <th>Общая сумма:</th>
	                        <td class="text-right text-primary"><h5 class="font-weight-semibold">{if $order->amount ne 0}{$order->amount|number_format:0:".":" "} сум.{/if}</h5></td>
                        </tr>
                        </tbody>
                    </table>
                </div>

                <div class="text-right mt-3">
                    <button type="button" class="btn btn-primary btn-labeled btn-labeled-left"><b><i class="icon-paperplane"></i></b> Отправить счет-фактуру</button>
                </div>
            </div>
        </div>
    </div>

    <div class="card-footer">
        <span class="text-muted">
            Спасибо за заказ.
            Этот счет может быть оплачен через PayMe, Click.
            Поздняя оплата возможна, но с платой на 10% в месяц.
            Компания, зарегистрированная в Узбекистане #, зарегистрированный
            офис: {$config.address}.
            Номер телефона: {$config.phone}
        </span>
    </div>

    <div class="modal-footer bg-transparent">
        <button type="button" class="btn btn-light" data-dismiss="modal">Закрыть</button>
    </div>
</div>
{/if}

