<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=languages" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item"  href="index.php?mod=language&action=add"><i class="icon-plus3"></i> {languages:add}</a>
				{if $LANGUAGES|@count > 1 AND empty($SITE_LANG)} &nbsp;&nbsp;
                    <a class="breadcrumb-elements-item" href="javascript:;" data-toggle="collapse" data-target="#changeLangRow"><i class="icon-sort"></i> {languages:changeDefaultLang}</a>
                {/if}
			</div>
		</div>
	</div>
</div>

{if isset($action) && $action == 'confirmDelete'}

<div class="content">
    <div class="row">
    	<div class="col-md-12">
        	
            <div class="card"> 
                
                <div class="card-body">
        	         <form action="index.php?mod=languages" method="post" id="language">
                        {languages:delete}
                        <p>{if !$language->isDefault} {languages:deleteDesc} {/if}</p>
                        <div class="form-check">
							<label class="form-check-label">
								<div class="uniform-checker">
                                    <input type="checkbox" class="form-check-input-styled" onclick="document.getElementById('submitBtn').disabled = !this.checked;" id="confirmDelete" data-fouc="">
								</div>
								{languages:confirmDelete}: <b>{$language->languageName}</b>
							</label>
						</div>
                        <div align="center" class="mt-3">
                            <input type="hidden" name="id" value="{$language->languageId}" />
                            <input type="hidden" name="action" value="remove" />
                            <button class="btn btn-sm btn-primary" type="button" id="submitBtn" disabled="disabled" onclick="this.form.submit()" >&nbsp; {general:delete} &nbsp;</button>
                            <input class="btn btn-sm btn-primary" type="button" value="{general:cancel}" onclick="javascript:document.location='index.php?mod=languages'" />
                        </div>
                    </form>
                </div>
            </div>
        
    	</div>
    </div>
</div>

{else}
<div class="content">
    <div class="row">
    	<div class="col-md-12">
        	
        	<div id="changeLangRow" class="collapse">
                <div class="card"> 

                    <div class="card-body">
            	        <form action="index.php?mod=languages" method="post" id="searchForm" onclick="confirmLanguageChange(this)">
            	    	    <div class="row justify-content-md-center">
                                <div class="col-md-6">
                                    {html_options options=$defaultLanguageOptions id=defaultLang name="language[languageId]" class="form-control select"}
                                </div>
                                <div class="col-md-3">
                                    <button  class="btn btn-sm btn-primary" type="submit" name="action" value="changeDefaultLanguage">{languages:setAsDefault}</button> 
                                </div>
            	    	    </div>            
                        </form>
                    </div>
                </div>
            </div>
        	
            <div class="card">    
                <table class="table table-togglable table-striped table-hover" id="languages">
                    <thead>
                        <tr>
                            <th data-hide="phone" class="text-center">#</th>
                            <th data-hide="phone" class="text-center" nowrap="nowrap">{languages:codename}</th>
                            <th data-hide="phone" >{languages:flag}</th>
                            <th data-toggle="true">{languages:language}</th>
                            <th class="text-center">{languages:status}</th>
                                 
                            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($languages)}
                    <tbody class="selectable-demo-list language_list" id="language_list"> 
                        {foreach item=language from=$languages name=languages}
                        <tr id="language-{$language->languageId}" data-id="{$language->languageId}">
	                        <td class="move_zone" nowrap="nowrap"><i class="icon-menu8" style="opacity: 0.5"></i> </td>
                            <td class="text-center" nowrap="nowrap"> <a href="{$language->url}" target="_blank">{$language->codename}</a></td>
                            <td class="text-center" nowrap="nowrap"><img src="{$GLOBAL_URL}/admin/assets/lang/{$language->codename}.png" style="width: 30px;"></td>
                            <td width="100%">{$language->languageTransName|default:$navLang->languageName}{if $language->isDefault} (<b>{languages:default}</b>){/if}</td>
    
                            <td class="text-center" nowrap="nowrap">
                                {if !$language->isDefault}
                                <label class="form-check-label">
    								<input type="checkbox" class="form-check-input-switchery ajax_action {if $language->status eq 'visible'}active_class{/if}" data-module="languages" data-action="status" data-id="{$language->languageId}" name="status" value="1" {if $language->status eq 'visible'}checked{/if} data-fouc>
    							</label>
                                
                                {/if}
                            </td>
                            <td class="text-center">
                                <div class="list-icons">
    								<div class="list-icons-item dropdown">
    									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
    
    									<div class="dropdown-menu dropdown-menu-right">
    										<a class="dropdown-item" href="index.php?mod=language&action=edit&id={$language->languageId}"><i class="icon-pencil7"></i> {general:edit}</a>
    										{if !$language->isDefault}
        										<div class="dropdown-divider"></div>
        										<a href="index.php?mod=languages&action=confirmDelete&id={$language->languageId}" class="dropdown-item" ><i class="icon-cross2"></i> {general:delete}</a>
    										{/if}
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}
    
                    </tbody>
                    
                    {else}
                    <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
            </div>
    	</div>
    </div>
</div>
{/if}


{if isset($messages.saved)}<span id="savedMessage" onclick="new Noty({ text: '{languages:messages:0}', type: 'success', timeout: 1500 }).show();"></span>{/if}
{if isset($messages.deleted)}<span id="deletedMessage" onclick="new Noty({ text: '{languages:messages:1}', type: 'success', timeout: 1500 }).show();"></span>{/if}

{if isset($errors.language_not_found)}<span id="languageNotFoundError" onclick="new Noty({ text: '{languages:errors:1}', type: 'error', timeout: 1500 }).show();"></span>{/if}
{if isset($errors.serializations)}<span id="serializationsError" onclick="new Noty({ text: '{languages:errors:6}', type: 'error', timeout: 1500 }).show();"></span>{/if}

 <script>
    $(document).ready(function () {
        {if isset($errors.language_not_found)} $('#languageNotFoundError').click(); {/if}
        {if isset($errors.htaccess)} $('#htaccessError').click();{/if}
        {if isset($errors.serializations)} $('#serializationsError').click();{/if}

        {if isset($messages.saved)} $('#savedMessage').click();{/if}
        {if isset($messages.deleted)} $('#deletedMessage').click();{/if}
    });
     
    function reorderMessage(){ new Noty({ text: '{languages:messages:2}', type: 'success', timeout: 1500 }).show(); }
    function moveError(){ new Noty({ text: '{languages:errors:8}', type: 'error', timeout: 1500 }).show(); }
    function deletedMessage(){ new Noty({ text: '{languages:messages:1}', type: 'success', timeout: 1500 }).show(); }
    function successMessage(){ new Noty({ text: '{languages:messages:5}', type: 'success', timeout: 1500 }).show(); }
    function errorMessage(){ new Noty({ text: '{languages:errors:10}', type: 'error', timeout: 3000 }).show(); }
    
    $("#language_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.language_list',
        placeholder	: "ui-sortable-handle",
        update		: function(event, ui){
            
		    var languageIds = new Array();
		    
            $('#language_list tr').each(function() {
                languageIds.push($(this).attr("data-id"));
		    });

            $.ajax({
			    url:"index.php?mod=languages&action=reorder",
                method:"POST",
                data:{ languageIds: languageIds },
                success:function(data) {
                    reorderMessage();
                    setTimeout(function(){
                        location.reload();
                    },2500);
				    //alert(data);
			    }
		    });
	    }
    }).disableSelection();
   
</script>





