<form method="post" id="language" class="form-content-wrapper">
    <input type="hidden" name="language[languageId]" value="{if isset($language->languageId)}{$language->languageId}{/if}" />
	{if isset($action.toMultilangMode)}<input type="hidden" name="language[isDefault]" value="1" />{/if}
    
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
                    {if !isset($action.toMultilangMode)} &nbsp;
                        <a class="btn btn-sm btn-primary" href="index.php?mod=languages">{general:cancel}</a>
                    {/if}
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="index.php?mod=languages" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>
    <!-- /page header -->
    
    
    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
            			    <div class="col-md-6">
                                {if !isset($language->languageId)}
                                    <div class="form-group form-group-float">
                                        <label class="form-group-float-label is-visible">{languages:predefinedLanguages}</label>
                                        {if isset($language->codename)}
                                            {html_options options=$languageOptions selected=$language->codename name=languageOptions onChange="languageOptionChange(this)" class="form-control select"}
                                        {else}
                                            {html_options options=$languageOptions name=languageOptions onChange="languageOptionChange(this)" class="form-control select"}
                                        {/if}
                                    </div>
                                {/if}
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.languageName)}text-danger{/if}">{languages:language}</label>
                                    <input type="text" class="form-control" autocomplete="off" id="languageName" name="language[languageName]" value="{if isset($language->languageName)}{$language->languageName}{/if}" placeholder="{languages:languageDesc}">
                                </div>

                                {if !isset($language->languageId)}
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.codename) || isset($errors.codenameExists) || isset($errors.codenameCharacters)}text-danger{/if}">{languages:codename}</label>
                                    <input class="form-control" autocomplete="off" id="codename" type="text" name="language[codename]" value="{if isset($language->codename)}{$language->codename}{/if}" placeholder="{languages:codenameDesc}"/>
                                </div>
                                {/if}
            			    </div>
            			    
                            <div class="col-md-6">

                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">Название языка отображаемого на сайте {*languages:language*}</label>
                                    <input type="text" class="form-control" autocomplete="off" id="name" name="language[name]" value="{if isset($language->name)}{$language->name}{/if}" placeholder="{languages:languageDesc}">
                                </div>
                                {if !isset($action.toMultilangMode)}
                                    {if !isset($language->languageId)}
                                    <div class="form-group form-group-float">
                                        <label class="form-group-float-label is-visible">{settings:regional:adminLang}</label>
                                        <script type="text/javascript">
                                            lang2charset = {ldelim}	{foreach item=charset key=lang from=$languageCharsets name=languageCharsets}"{$lang}":"{$charset}"
                                            {if !$smarty.foreach.languageCharsets.last},{/if}{/foreach} {rdelim};
                                        </script>
                                        {html_options options=$adminLangs name="language[admin_language]" id="adminLanguageOptions" class="form-control select"}
                                    </div>
                                    <div class="form-group form-group-float">
                                        <label class="form-group-float-label is-visible">{settings:regional:charset}</label>
                                        {html_options options=$charsetOptions name="language[charset]" id="charsetOptions" class="form-control select"}
                                    </div>
                                    {/if}
                                {/if}
            			    </div>
                        </div> 
                    </div>
    		    </div>
    
                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
                    {if !isset($action.toMultilangMode)} &nbsp;
                        <a class="btn btn-sm btn-primary" href="index.php?mod=languages">{general:cancel}</a>
                    {/if}
                   
                </div>
            </div>
    
    
            <div class="col-md-4">
        		<div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div>
                		</div>
    				</div>
    				<div class="card-body">
        				<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{languages:status}</label>
                            {if isset($language->status)}
                                {html_options options=$statuses name="language[status]" id="status" selected=$language->status class="form-control select"}
                            {else}
                                {html_options options=$statuses name="language[status]" id="status" class="form-control select"}
                            {/if}
                        </div>

                        {if isset($language->modifiedOn)}
                        <div class="d-sm-flex flex-sm-wrap mb-3">
    						<div class="font-weight-semibold">{general:modified}</div>
    						<div class="ml-sm-auto mt-2 mt-sm-0">{$language->modifiedOn} ({$language->modifiedBy->loginName|default:"{general:unknowUser}"})</div>
    					</div>
                        {/if}

                        {if isset($language->addedOn)}
                        <div class="d-sm-flex flex-sm-wrap mb-3">
    						<div class="font-weight-semibold">{general:created}</div>
    						<div class="ml-sm-auto mt-2 mt-sm-0">{$language->addedOn} ({$language->addedBy->loginName|default:"{general:unknowUser}"})</div>
    					</div>
                           
                        {/if}
    				</div>
    			</div>
            </div>
        </div>
    </div>

</form>
 
    
{if isset($messages.saved)}<span id="savedMessage" onclick="new Noty({ text: '{languages:messages:0}', type: 'success', timeout: 1500 }).show();"></span>{/if}
{if isset($messages.deleted)}<span id="deletedMessage" onclick="new Noty({ text: '{languages:messages:1}', type: 'success', timeout: 1500 }).show();"></span>{/if}

{if isset($errors.not_saved)}<span id="notSavedError" onclick="new Noty({ text: '{languages:errors:0}', type: 'error', timeout: 1500 }).show();"></span>{/if} 
{if isset($errors.language_not_found)}<span id="languageNotFoundError" onclick="new Noty({ text: '{languages:errors:1}', type: 'error', timeout: 1500 }).show();"></span>{/if}
{if isset($errors.languageName)}<span id="languageNameError" onclick="new Noty({ text: '{languages:errors:2}', type: 'error', timeout: 1500 }).show();"></span>{/if}
{if isset($errors.codename)}<span id="codenameError" onclick="new Noty({ text: '{languages:errors:3}', type: 'error', timeout: 1500 });"></span>{/if}
{if isset($errors.codenameExists)}<span id="codenameExistsError" onclick="new Noty({ text: '{languages:errors:4}', type: 'error', timeout: 1500 }).show();"></span>{/if} 
{if isset($errors.htaccess)}<span id="htaccessError" onclick="new Noty({ text: '{languages:errors:5}', type: 'error', timeout: 1500 }).show();"></span>{/if} 
{if isset($errors.serializations)}<span id="serializationsError" onclick="new Noty({ text: '{languages:errors:6}', type: 'error', timeout: 1500 }).show();"></span>{/if}
{if isset($errors.codenameCharacters)}<span id="codenameCharactersError" onclick="new Noty({ text: '{languages:errors:7}', type: 'error', timeout: 1500 }).show();"></span>{/if} 
{if isset($errors.languageNameCharacters)}<span id="languageNameCharactersError" onclick="new Noty({ text: '{languages:errors:9}', type: 'error', timeout: 1500 }).show();"></span>{/if}
 
<script>
  	
$(document).ready(function () {
    {if isset($errors.not_saved)} $('#notSavedError').click();{/if}
    {if isset($errors.language_not_found)} $('#languageNotFoundError').click(); {/if}
    {if isset($errors.languageName)} $('#languageNameError').click();{/if}
    {if isset($errors.codename)} $('#codenameError').click();{/if}
    {if isset($errors.codenameExists)} $('#codenameExistsError').click();{/if}
    {if isset($errors.htaccess)} $('#htaccessError').click();{/if}
    {if isset($errors.serializations)} $('#serializationsError').click();{/if}
    {if isset($errors.codenameCharacters)} $('#codenameCharactersError').click();{/if}
    {if isset($errors.languageNameCharacters)} $('#languageNameCharactersError').click();{/if}
    
    {if isset($messages.saved)} $('#savedMessage').click();{/if}
    {if isset($messages.deleted)} $('#deletedMessage').click();{/if}
});
function moveUpMessage(){ new Noty({ text: '{sections:messages:3}', type: 'warning', timeout: 1500 }).show(); }
function moveDownMessage(){ new Noty({ text: '{sections:messages:4}', type: 'warning', timeout: 1500 }).show(); }
  
document.getElementById('language').languageName.focus();

{if isset($action.toMultilangMode)}

    var website_language = '{$config.website_language}';
    
    var languageOptions = document.getElementById('languageOptions').options;
    for (i = 0; i < languageOptions.length; i++) {
    	if (languageOptions[i].value == website_language) {
    		languageOptions[i].selected = true;
    		languageOptionChange(languageOptions);
    		break;
    	}
    }

{/if}
</script>
