<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{if $title}{$title} - {/if}{productName}</title>

	<link rel="apple-touch-icon" sizes="57x57" href="/admin/assets/favicon/apple-icon-57x57.png">
	<link rel="apple-touch-icon" sizes="60x60" href="/admin/assets/favicon/apple-icon-60x60.png">
	<link rel="apple-touch-icon" sizes="72x72" href="/admin/assets/favicon/apple-icon-72x72.png">
	<link rel="apple-touch-icon" sizes="76x76" href="/admin/assets/favicon/apple-icon-76x76.png">
	<link rel="apple-touch-icon" sizes="114x114" href="/admin/assets/favicon/apple-icon-114x114.png">
	<link rel="apple-touch-icon" sizes="120x120" href="/admin/assets/favicon/apple-icon-120x120.png">
	<link rel="apple-touch-icon" sizes="144x144" href="/admin/assets/favicon/apple-icon-144x144.png">
	<link rel="apple-touch-icon" sizes="152x152" href="/admin/assets/favicon/apple-icon-152x152.png">
	<link rel="apple-touch-icon" sizes="180x180" href="/admin/assets/favicon/apple-icon-180x180.png">
	<link rel="icon" type="image/png" sizes="192x192"  href="/admin/assets/favicon/android-icon-192x192.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/admin/assets/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="96x96" href="/admin/assets/favicon/favicon-96x96.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/admin/assets/favicon/favicon-16x16.png">
	<link rel="manifest" href="/admin/assets/favicon/manifest.json">
	<meta name="msapplication-TileColor" content="#ffffff">
	<meta name="msapplication-TileImage" content="/admin/assets/favicon/ms-icon-144x144.png">
	<meta name="theme-color" content="#ffffff">

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/icons/fontawesome/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/icons/material/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
    <link href="/admin/assets/css/media.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/gallery.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="/admin/assets/js/main/jquery.min.js"></script>
	<script src="/admin/assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="/admin/assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/ripple.min.js"></script>
	<script src="/admin/assets/js/plugins/bootbox/bootbox.min.js"></script>
	<script src="/admin/assets/js/plugins/loaders/progressbar.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="/admin/assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/fixed_header.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/row_reorder.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/col_reorder.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/buttons.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/select.min.js"></script>
	<script src="/admin/assets/js/plugins/tables/datatables/extensions/editor.js"></script>

	<script src="/admin/assets/js/plugins/visualization/d3/d3.min.js"></script>
	<script src="/admin/assets/js/plugins/visualization/d3/d3_tooltip.js"></script>
	<script src="/admin/assets/js/plugins/ui/dragula.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/styling/uniform.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/styling/switch.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/moment/moment.min.js"></script>
	<script src="/admin/assets/js/plugins/pickers/daterangepicker.js"></script>
	<script src="/admin/assets/js/plugins/pickers/anytime.min.js"></script>
	<script src="/admin/assets/js/plugins/pickers/pickadate/picker.js"></script>
	<script src="/admin/assets/js/plugins/pickers/pickadate/picker.date.js"></script>
	<script src="/admin/assets/js/plugins/pickers/pickadate/picker.time.js"></script>
	<script src="/admin/assets/js/plugins/pickers/pickadate/translations/{$config.admin_language}.js"></script>
	<script src="/admin/assets/js/plugins/forms/selects/bootstrap_multiselect.js"></script>
	<script src="/admin/assets/js/plugins/tables/footable/footable.min.js"></script>
	<script src="/admin/assets/js/plugins/uploaders/dropzone.min.js"></script>

	<script src="/admin/assets/js/plugins/uploaders/fileinput/fileinput.min.js"></script>
	<script src="/admin/assets/js/plugins/sliders/nouislider.min.js"></script>
	<script src="/admin/assets/js/plugins/extensions/jquery_ui/interactions.min.js"></script>
	<script src="/admin/assets/js/plugins/extensions/jquery_ui/touch.min.js"></script>
	<script src="/admin/assets/js/plugins/notifications/jgrowl.min.js"></script>
	<script src="/admin/assets/js/plugins/notifications/noty.min.js"></script>
	<script src="/admin/assets/js/plugins/uploaders/fileinput/plugins/purify.min.js"></script>
	<script src="/admin/assets/js/plugins/uploaders/fileinput/fileinput.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/tags/tagsinput.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/tags/tokenfield.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/typeahead/typeahead.bundle.min.js"></script>
	<script src="/admin/assets/js/plugins/media/fancybox.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/inputmask.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/autosize.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/formatter.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/typeahead/typeahead.bundle.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/typeahead/handlebars.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/passy.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/maxlength.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/validation/validate.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/inputs/touchspin.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/styling/switch.min.js"></script>
	<script src="/admin/assets/js/plugins/forms/wizards/steps.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/prism.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/sticky.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/nestable.js"></script>
	<script src="/admin/assets/js/plugins/extensions/cookie.js"></script>
	<script src="/admin/assets/js/plugins/clipboard/clipboard.min.js"></script>

	<!-- /theme JS files -->
	<script src="https://code.jquery.com/ui/1.11.1/jquery-ui.min.js"></script>
	<script src="/admin/assets/js/app.js"></script>
	<script src="/admin/assets/js/script.js"></script>
{*	<script src="/admin/assets/js/bbcodes.js"></script>*}

	<script>
        var lang = [];
        {foreach key=langKey item=langVal from=$jsLang}
        lang['{$langKey}'] = '{$langVal}';
        {/foreach}
    </script>

</head>

<body class="navbar-top {if isset($smarty.session.sidebar) AND $smarty.session.sidebar eq 1}sidebar-xs{/if}">

	<!-- Main navbar -->
	<div class="navbar navbar-expand-md navbar-dark{* bg-indigo*} navbar-static fixed-top">
		<div class="navbar-brand">
			<a href="index.php?mod=overview" class="d-inline-block">
				<img src="/admin/assets/images/logo_light.png" alt="{productName}">
			</a>
		</div>

		<div class="d-md-none">
			<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar-mobile"><i class="icon-tree5"></i></button>
			<button class="navbar-toggler sidebar-mobile-main-toggle" type="button"><i class="icon-paragraph-justify3"></i></button>
		</div>

		<div class="collapse navbar-collapse" id="navbar-mobile">
			{if isset($adminManager->manager)}
			<ul class="navbar-nav">
				<li class="nav-item">
					<a class="navbar-nav-link sidebar-control sidebar-main-toggle d-none d-md-block" onclick="miniSidebar()">
						<i class="icon-paragraph-justify3" data-user="{$adminManager->manager->userId}"></i>
					</a>
				</li>
			</ul>
			{else}
				<ul class="navbar-nav">
					<li class="nav-item">
						<a class="navbar-nav-link sidebar-control sidebar-main-toggle d-none d-md-block">
							<i class="icon-paragraph-justify3"></i>
						</a>
					</li>
				</ul>
			{/if}
            <span class="navbar-text ml-md-3">
			    <span class="badge badge-mark border-orange-300 mr-2"></span> Добро пожаловать</span>
			<ul class="navbar-nav ml-auto">
{*    			<li class="nav-item dropdown">*}
{*					<a href="#" class="navbar-nav-link dropdown-toggle caret-0" data-toggle="dropdown">*}
{*						<i class="icon-people"></i>*}
{*						<span class="d-md-none ml-2">Users</span>*}
{*					</a>*}
{*					*}
{*					<div class="dropdown-menu dropdown-menu-right dropdown-content wmin-md-300">*}
{*						<div class="dropdown-content-header">*}
{*							<span class="font-weight-semibold">Users online</span>*}
{*							<a href="index.php?mod=users" class="text-default"><i class="icon-search4 font-size-base"></i></a>*}
{*						</div>*}

{*						<div class="dropdown-content-body dropdown-scrollable">*}
{*							<ul class="media-list">*}
{*								<li class="media">*}
{*									<div class="mr-3">*}
{*										<img src="/admin/assets/images/demo/users/face18.jpg" width="36" height="36" class="rounded-circle" alt="">*}
{*									</div>*}
{*									<div class="media-body">*}
{*										<a href="index.php?mod=user&id=" class="media-title font-weight-semibold">Jordana Ansley</a>*}
{*										<span class="d-block text-muted font-size-sm">Lead web developer</span>*}
{*									</div>*}
{*									<div class="ml-3 align-self-center"><span class="badge badge-mark border-success"></span></div>*}
{*								</li>*}
{*							</ul>*}
{*						</div>*}

{*						<div class="dropdown-content-footer bg-light">*}
{*							<a href="index.php?mod=users" class="text-grey mr-auto">All users</a>*}
{*							<a href="index.php?mod=users" class="text-grey"><i class="icon-gear"></i></a>*}
{*						</div>*}
{*					</div>*}
{*				</li>*}
			

{*				<li class="nav-item dropdown">*}
{*					<a href="#" class="navbar-nav-link">*}
{*						<i class="icon-bell2"></i>*}
{*						<span class="d-md-none ml-2">Notifications</span>*}
{*						<span class="badge badge-mark border-white ml-auto ml-md-0"></span>*}
{*					</a>*}
{*				</li>*}
{*				{$langCount|@print_r}*}
				{if $LANGUAGES|@count > 1}
				<li class="nav-item dropdown">
				    {foreach item=navLang from=$LANGUAGES}{if ($SITE_LANG eq $navLang->codename) || (!$SITE_LANG && $navLang->isDefault)}
					<a href="#" class="navbar-nav-link dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
						<img src="{$GLOBAL_URL}/admin/assets/images/lang/{$navLang->codename}.png" class="img-flag mr-2" alt="{$navLang->codename}">
						{$navLang->languageTransName|default:$navLang->languageName}
					</a>
                    {/if}{/foreach}
					<div class="dropdown-menu dropdown-menu-right">
    					{foreach item=navLang from=$LANGUAGES}
						<a href="{$GLOBAL_URL}/admin/{if !$navLang->isDefault}{$navLang->codename}/{/if}{$smarty.const.REQUESTED_FILE}" class="dropdown-item english
    						{if ($SITE_LANG eq $navLang->codename) || (!$SITE_LANG && $navLang->isDefault)}active{/if}">
    						<img src="{$GLOBAL_URL}/admin/assets/images/lang/{$navLang->codename}.png" class="img-flag" alt="{$navLang->codename}">
							{$navLang->languageTransName|default:$navLang->languageName}
						</a>
						{/foreach}
					</div>
				</li>
				{/if}
				{if isset($totalPendingComments) && $totalPendingComments > 0}
{*
                    <li class="xn-icon-button pull-right">
                        <a href="#"><span class="fa fa-comments"></span></a>
                        {if $totalPendingComments > 0}<div class="informer informer-danger">{$totalPendingComments}</div>{else}{/if}
                        <div class="panel panel-primary animated zoomIn xn-drop-left xn-panel-dragging">
                            <div class="panel-heading">
                                <h3 class="panel-title" style="line-height: 30px;"><span class="fa fa-comments"></span> {comments:news}</h3>
                                <div class="pull-right">
                                    {if $totalPendingComments > 0}<span class="label label-danger"> {$totalPendingComments}</span>{else}{/if}
                                </div>
                            </div>

                            <div class="panel-body list-group list-group-contacts scroll" style="height: 200px;">
                                {if $totalPendingComments > 0}
                                    {foreach item=comment from=$comments name=comments}{if $comment.status eq "pending"}
                                        <a href="index.php?mod=comment&action=edit&id={$comment.commentId}&{if isset($page)}page={$page}{/if}" class="list-group-item" >
                                            <span class="fa fa-comments" {if $comment.status eq "pending"}style="color: #a00;"{/if}></span>
                                        
                                                {$comment.authorName|truncate:20}

                                            <span class="contacts-title">{$comment.authorEmail|truncate:20}</span><p>{$comment.content|strip_tags|truncate:200}</p>
                                        </a>
                                    {/if}{/foreach}
                                {else}
                                    <a class="list-group-item"><h5 class="text-center">Новых комментарий нет</h5></a>
                                {/if}
                            </div>
                            <div class="panel-footer text-center"><a href="index.php?mod=comments">Все комментарии</a></div>
                        </div>
                    </li>
*}
               
                <li class="nav-item dropdown">
					<a href="#" class="navbar-nav-link dropdown-toggle caret-0" data-toggle="dropdown">
						<i class="icon-bubbles4"></i>
						<span class="d-md-none ml-2">{comments:news}</span>
						{if $totalPendingComments > 0}<span class="badge badge-pill bg-warning-400 ml-auto ml-md-0">{$totalPendingComments}</span>{/if}
					</a>

					<div class="dropdown-menu dropdown-menu-right dropdown-content wmin-md-350">
						{if $totalPendingComments > 0}
							<div class="dropdown-content-header">
								<span class="font-weight-semibold">{comments:news}</span>
								<a href="index.php?mod=comments" class="text-default"><i class="icon-compose"></i></a>
							</div>
						{else}
							<div class="dropdown-content-header">
								<span class="font-weight-semibold">Новых комментарий нет</span>
								<a href="index.php?mod=comments" class="text-default"><i class="icon-compose"></i></a>
							</div>
						{/if}

						<div class="dropdown-content-body dropdown-scrollable">
							<ul class="media-list">
								{if $totalPendingComments > 0}
									{foreach item=comment from=$comments name=comments}{if $comment->status eq "pending"}
									<li class="media">
										<div class="mr-3 position-relative">
											<img src="/admin/assets/images/demo/users/face10.jpg" width="36" height="36" class="rounded-circle" alt="">
										</div>

										<div class="media-body">
											<div class="media-title">
												<a href="index.php?mod=comment&action=edit&id={$comment->commentId}&{if isset($page)}page={$page}{/if}">
													<span class="font-weight-semibold"> {$comment->authorName|truncate:20}</span>
													<span class="text-muted float-right font-size-sm">{$comment->authorEmail|truncate:20}</span>
												</a>
											</div>

											<span class="text-muted">{$comment->content|strip_tags|truncate:200}</span>
										</div>
									</li>
									{/if}{/foreach}

                                {/if}
							</ul>
						</div>

						<div class="dropdown-content-footer justify-content-center p-0">
							<a href="index.php?mod=comments" class="bg-light text-grey w-100 py-2" data-popup="tooltip" title="Все комментарии"><i class="icon-menu7 d-block top-0"></i></a>
						</div>
					</div>
				</li>
				{/if}
				<li class="nav-item">
					<a href="{$SITE_URL}/" class="navbar-nav-link" target="_blank"> <i class="icon-earth"></i> </a>
				</li>
				<li class="nav-item dropdown dropdown-user">
					{if isset($adminManager->manager)}
					<a href="#" class="navbar-nav-link d-flex align-items-center dropdown-toggle" data-toggle="dropdown">
						<img src="{if isset($adminManager->manager->image)}{$adminManager->manager->image->large}{else}/admin/assets/img/no_images.jpg{/if}" alt="{$adminManager->manager->fullName}" class="rounded-circle mr-2" height="34"/>
						<span>{$adminManager->manager->fullName}</span>
					</a>
						<div class="dropdown-menu dropdown-menu-right">
							<a href="index.php?mod=manager&action=edit&id={$adminManager->manager->userId}" class="dropdown-item"><i class="icon-cog5"></i> Настройки аккаунта</a>
							<a href="index.php?mod=manager&action=add" class="dropdown-item"><i class="icon-user-plus"></i> Добавить аккаунт</a>
{*							<a href="#" class="dropdown-item"><i class="icon-comment-discussion"></i> Messages <span class="badge badge-pill bg-blue ml-auto">58</span></a>*}
							<div class="dropdown-divider"></div>
							<a href="index.php?mod=auth&action=logout" class="dropdown-item"><i class="icon-switch2"></i> Выйти</a>
						</div>
					{else}
						<a href="#" class="navbar-nav-link d-flex align-items-center dropdown-toggle" data-toggle="dropdown">
							<img src="{$GLOBAL_URL}/admin/assets/img/no_images.jpg" alt="UNKNOWN" class="rounded-circle mr-2" height="34" alt=""/>
							<span>UNKNOWN</span>
						</a>
						<div class="dropdown-menu dropdown-menu-right">
							<a href="index.php?mod=auth&action=logout" class="dropdown-item"><i class="icon-switch2"></i> Выйти</a>
						</div>
					{/if}


				</li>
			</ul>
		</div>
	</div>
	<!-- /main navbar -->


	<!-- Page content -->
	<div class="page-content">

		<!-- Main sidebar -->
		<div class="sidebar sidebar-dark sidebar-main sidebar-fixed sidebar-expand-md">

			<!-- Sidebar mobile toggler -->
			<div class="sidebar-mobile-toggler text-center">
				<a href="#" class="sidebar-mobile-main-toggle"> <i class="icon-arrow-left8"></i></a> Меню
				<a href="#" class="sidebar-mobile-expand">
					<i class="icon-screen-full"></i>
					<i class="icon-screen-normal"></i>
				</a>
			</div>
			<!-- /sidebar mobile toggler -->


			<!-- Sidebar content -->
			<div class="sidebar-content">

{*                <div class="sidebar-user">*}
{*					<div class="card-body">*}
{*						<div class="media">*}
{*							<div class="mr-3">*}
{*								<a href="index.php?mod=manager&action=edit&id={$adminManager->manager->userId}">*}
{*									<img src="{if isset($adminManager->manager->image)}{$adminManager->manager->image->large}{else}/admin/assets/img/no_images.jpg{/if}" alt="{$adminManager->manager->fullName}" width="38" height="38" class="rounded-circle"/>*}
{*                                </a>*}
{*							</div>*}

{*							<div class="media-body">*}
{*								<div class="media-title font-weight-semibold">{$adminManager->manager->fullName}</div>*}
{*								<div class="font-size-xs opacity-50">*}
{*									<i class="icon-pin font-size-sm"></i> &nbsp;{$adminManager->manager->accessLevelName}*}
{*								</div>*}
{*							</div>*}

{*							<div class="ml-3 align-self-center">*}
{*								<a href="index.php?mod=manager&action=edit&id={$adminManager->manager->userId}" class=""><i class="icon-cog3"></i></a>*}
{*							</div>*}
{*						</div>*}
{*					</div>*}
{*				</div>*}

				<!-- User menu -->
				<div class="sidebar-user-material">
					{if isset($adminManager->manager)}
					<div class="sidebar-user-material-body">
						<div class="card-body text-center">
							<a href="index.php?mod=manager&action=edit&id={$adminManager->manager->userId}">
								<img src="{if isset($adminManager->manager->image)}{$adminManager->manager->image->large}{else}/admin/assets/img/no_images.jpg{/if}" alt="{$adminManager->manager->fullName}" class="img-fluid rounded-circle shadow-1 mb-3" width="80" height="80"/>
							</a>
							<h6 class="mb-0 text-white text-shadow-dark">{$adminManager->manager->fullName}</h6>
							<span class="font-size-sm text-white text-shadow-dark">{$adminManager->manager->accessLevelName}</span>
						</div>

						<div class="sidebar-user-material-footer">
							<a href="#user-nav" class="d-flex justify-content-between align-items-center text-shadow-dark dropdown-toggle" data-toggle="collapse"><span>Аккаунт</span></a>
						</div>
					</div>

					<div class="collapse" id="user-nav">
						<ul class="nav nav-sidebar">
							<li class="nav-item"><a href="index.php?mod=manager&action=edit&id={$adminManager->manager->userId}" class="nav-link"><i class="icon-cog5"></i> <span>Настройки аккаунта</span></a></li>
							<li class="nav-item"><a href="index.php?mod=manager&action=add" class="nav-link"><i class="icon-user-plus"></i> <span>Добавить аккаунт</span></a></li>
							<li class="nav-item"><a href="index.php?mod=auth&action=logout" class="nav-link"><i class="icon-switch2"></i> <span>Выйти</span></a></li>
						</ul>
					</div>
					{/if}
				</div>
				<!-- /user menu -->


				<!-- Main navigation -->
				<div class="card card-sidebar-mobile">
					<ul class="nav nav-sidebar" data-nav-type="accordion">
						<li class="nav-item-header"><div class="text-uppercase font-size-xs line-height-xs">Main</div> <i class="icon-menu" title="Main"></i></li>
						<li class="nav-item">
							<a href="index.php?mod=main" class="nav-link {if ($activeItem eq 'main')}active{/if}"><i class="icon-home4"></i><span>Dashboard</span></a>
						</li>
						<!-- Main -->
						{if isset($adminManager->manager)}
							{foreach from=$menu item=itemMenu}
	                            <li class="nav-item nav-item-submenu {foreach from=$itemMenu.activeItems item=active}{if ($activeItem eq $active)}nav-item-expanded nav-item-open{/if}{/foreach}">
	                                <a href="javascript:void('');" class="nav-link"> <i class="{$itemMenu.icon}"></i> <span> {$itemMenu.name}</span></a>
	                                <ul class="nav nav-group-sub" data-submenu-title="{$itemMenu.name}">
	                                    {foreach from=$itemMenu.children item=subItemMenu}
	                                        <li class="nav-item">
	                                            <a class="nav-link {if $activeItem eq $subItemMenu.fileName}active legitRipple{/if}" href="index.php?mod={$subItemMenu.fileName}"><i class="{$subItemMenu.icon}"></i> {$subItemMenu.name}</a>
	                                        </li>
	                                    {/foreach}
	                                </ul>
	                            </li>
	                        {/foreach}
						{/if}
						<!-- /main -->

					</ul>
				</div>
				<!-- /main navigation -->

			</div>
			<!-- /sidebar content -->
			
		</div>
		<!-- /main sidebar -->

		<!-- Main content -->
		<div class="content-wrapper">

			{if $content}
			
                {$content nofilter}
                
            {else}
            
                <!-- Page header -->
    			<div class="page-header page-header-light">
    				<div class="page-header-content header-elements-md-inline">
    					<div class="page-title d-flex">
    						<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    						<a href="layout_fixed.html#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    					</div>
    
    					<div class="header-elements d-none">
    						<div class="d-flex justify-content-center">
    							<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
    {*
    							<a href="#" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-calculator text-pink-300"></i><span>Invoices</span></a>
    							<a href="#" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-calendar5 text-pink-300"></i><span>Schedule</span></a>
    *}
    						</div>
    					</div>
    				</div>
    
    				<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    					<div class="d-flex">
    						<div class="breadcrumb">
    							<a href="index.html" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
    							<a href="layout_fixed.html#" class="breadcrumb-item">Link</a>
    							<span class="breadcrumb-item active">Current</span>
    						</div>
    
    						<a href="layout_fixed.html#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    					</div>
    
    					<div class="header-elements d-none">
    						<div class="breadcrumb justify-content-center">
    							<a href="layout_fixed.html#" class="breadcrumb-elements-item">Link</a>
    
    							<div class="breadcrumb-elements-item dropdown p-0">
    								<a href="layout_fixed.html#" class="breadcrumb-elements-item dropdown-toggle" data-toggle="dropdown"> Dropdown</a>
    
    								<div class="dropdown-menu dropdown-menu-right">
    									<a href="layout_fixed.html#" class="dropdown-item">Action</a>
    									<a href="layout_fixed.html#" class="dropdown-item">Another action</a>
    									<a href="layout_fixed.html#" class="dropdown-item">One more action</a>
    									<div class="dropdown-divider"></div>
    									<a href="layout_fixed.html#" class="dropdown-item">Separate action</a>
    								</div>
    							</div>
    						</div>
    					</div>
    				</div>
    			</div>
    			<!-- /page header -->
                <!-- Content area -->
                <div class="content">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 mt-1">
                            <div class="boxed boxed_warning">
                                <div class="heading_box">
                                        <h1>Такого модуля не существует</h1>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            {/if}


			<!-- Footer -->
			<div class="navbar navbar-expand-lg navbar-dark">
				<div class="text-center d-lg-none w-100">
					<button type="button" class="navbar-toggler dropdown-toggle" data-toggle="collapse" data-target="#navbar-footer"> <i class="icon-unfold mr-2"></i> Footer </button>
				</div>

				<div class="navbar-collapse collapse" id="navbar-footer">
					<span class="navbar-text">
						&copy; 2001 - {$smarty.now|date_format:"%Y"}. MNV by <a href="https://www.life-style.uz/" target="_blank">Life Style</a>
					</span>

					<ul class="navbar-nav ml-lg-auto">
    					<li class="nav-item" style="padding-top: 3px;">
                            <a class="text-left">
                                <i class="icon-meter-fast"></i>&nbsp; Использовано памяти : {$debug_memory} Мб ({$debug_memusage} Мб макс)<br>
                                <i class="icon-history"></i>&nbsp; Время работы скрипта: {$debug_timer} мс
                            </a>
                        </li>
						<li class="nav-item"><a href="#" class="navbar-nav-link"><i class="icon-lifebuoy"></i></a></li>

						<li class="nav-item"><a href="" class="navbar-nav-link font-weight-semibold"><span class="text-pink-400"><i class="icon-cart2 mr-2"></i></span></a></li>
					</ul>
				</div>
			</div>
			<!-- /footer -->

		</div>
		<!-- /main content -->

	</div>
	<!-- /page content -->
	<style>
		.xdebug-error {
            z-index: 1000;
            position: relative;
            margin: auto;
        }
	</style>
	
<script>

    /* Call an ajax entity update */
    $(document).on("click", ".ajax_action", function () {
        ajax_action($(this));
    });


    if ($(".ajax_action")) {
        /* Функция аяксового обновления полей
        * state - состояние объекта (включен/выключен)
        * id - id обновляемой сущности
        * module - типо сущности
        * action - обновляемое поле (поле в БД)
        * класс "ajax_block" у елемента - означает массовое обновление;
        * если нужно:
        * 1) добавить класс "ajax_block" к блоку в котором хотите обновить несколько полей,
        * 2) добавить класс "ajax_element" к елементам, в блоке("ajax_block"), которые хотите обновить
        * .fn_ajax_element: аттрибут "name" - поле БД; val() - значение.
        * */
        function ajax_action($this) {
            var value, module, action, id;
            value = $this.hasClass("active_class") ? 0:1;
            id = parseInt($this.attr('data-id'));
            module = $this.attr("data-module");
            action = $this.attr("data-action");

            console.log(action);
            $.ajax({
                type: "POST",
                dataType: 'json',
                url: "index.php?mod="+module,
                data: { action: action, id: id, value: value },
                success: function(res){
                    console.log(res);
                    if (res.data === true) {
                        successMessage();
                        if (action === 'status') {
                            if (res.status === 'visible') {
                                $this.html('<i class="icon-eye"></i> {general:status}');
                                $('#status-'+id).text('{general:statuses:visible}');
                            } else {
                                $this.html('<i class="icon-eye-blocked"></i> {general:status}');
                                $('#status-'+id).text('{general:statuses:hidden}');
                            }

                        }
                    } else {
                        errorMessage();
                    }
                }
            });
            return false;
        }
    }
    function successMessage(){
        new Noty({
			text: '{general:restatus}',
			type: 'success'
        }).show();
    }
    function errorMessage(){
        new Noty({
			text: '{general:erestatus}',
			type: 'error'
        }).show();
    }

    function auto_keywords() {
        tinyMCE.triggerSave();
        var txt = document.getElementsByClassName('description')[0].value;
        // console.log(txt);
        $.post("/admin/handlers/keywords.php", { content: txt }, function(data) {
            console.log(data.keywords);
            $('#keywords').tokenfield('setTokens', data.keywords);
            // $('#keywords').tokenfield('setTokens', [data]);

        });
        return false;
    }
    // мини сайд бар
    function miniSidebar() {
        $.post('/admin/handlers/sidebar.php', function(data){
            console.log(data);
        }, 'json');
    }

</script>


</body>
</html>
