<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=brands" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">

				<a class="breadcrumb-elements-item" href="index.php?mod=brand&action=add{if isset($page)}&page={$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}" title="{general:add}"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
	<div class="card">
		<table class="table datatable-row-events brands-archive" id="brands">
			<thead>
				<tr>
					<th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
					<th data-hide="image" class="text-center">{general:table:image}</th>
					<th data-toggle="true">{general:table:product}</th>
					<th data-hide="phone" class="text-center">{general:table:status}</th>
					<th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
				</tr>
			</thead>
			{if isset($brands) && !empty($brands)}
				<tbody class="selectable-demo-list brands_list" id="brand_list"></tbody>
			{/if}
		</table>
	</div>
</div>

<style>
    table.fixedHeader-floating{
        position:fixed !important;
        background-color:white
    }
    table.fixedHeader-floating.no-footer{
        border-bottom-width:0
    }
    table.fixedHeader-locked {
        position:absolute !important;
        background-color:white
    }
    @media print{
        table.fixedHeader-floating{
            display:none
        }
    }
</style>
<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{brands:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
        
    });
    
    function deleteSuccess(id) {
        new Noty({ text: '{brands:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'brand');
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }


    $(document).ready(function () {
        {if isset($messages.saved)} $('#savedMessage').click();{/if}
    });

    var BrandList = function() {

        // Datatable
        var _componentDatatable = function() {
            if (!$().DataTable) {
                console.warn('Warning - datatables.min.js is not loaded.');
                return;
            }

            $.extend( $.fn.dataTable.defaults, {
                autoWidth: false,
                processing: true,
                serverSide: true,
                deferRender: true,
                stateSave: true,
                ajax: {
                    "url": "index.php?mod=brands",
                    "type": 'POST',
                    "data": { action: 'read_table' },
                    dataSrc: "data",
                    // success: function (data) {
                    //     console.log(data.data);
                    // },
                },
                'createdRow': function( row, data, dataIndex ) {
                   console.log(data);
                  console.log(dataIndex);
                    $(row).attr("data-id", data.brandId).attr("id", 'brand-'+data.brandId);
                },
                columns: [
                    { data: "brandId",
                        render: function (dataField) {
                            return '<td nowrap="nowrap">'  + dataField + '</td>';
                        }
                    },
                    { data: "image",
                        render: function (dataField) {
                            if (dataField) {
                                return '<img src="'+dataField +'" class="img-preview"/>';
                            } else {
                                return '<img src="/admin/assets/img/no_images.jpg" class="img-preview"/>';
                            }
                        }
                    },
                    { data: "name",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
                    { data: "status",
                        render: function (dataField) {
                            return "<td>" + dataField + "</td>";
                        }
                    },
                    { data: "brandId",
                        render: function (dataField, type, row) {
                           // console.log(row)
                            let active_class = '';
                            let icon_eye = '';
                            if (row.status == 'visible') {
                                active_class = 'active_class';
                                icon_eye = 'icon-eye';
                            } else {
                                icon_eye = 'icon-eye-blocked';
                            }
                            return '<td class="text-center"><div class="list-icons">' +
                                    '<div class="list-icons-item dropdown">' +
                                        '<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>' +
                                        '<div class="dropdown-menu dropdown-menu-right">' +
                                            '<a href="' + row.url + '" target="_blank" class="dropdown-item"><i class="icon-rotate-ccw2"></i> {general:view}</a>' +
                                            '<a class="dropdown-item" href="index.php?mod=brand&action=edit&id=' + dataField + '"><i class="icon-pencil7"></i> {general:edit}</a>' +
                                            '<a href="#" class="dropdown-item ajax_action ' + active_class + '" data-module="brands" data-action="status" data-id="' + dataField + '" name="status" value="1" ><i class="' + icon_eye + '"></i> {general:status}</a>' +

                                            '<div class="dropdown-divider"></div>' +
                                            '<a href="#" class="dropdown-item" onclick="remove(' + dataField + ', ' + dataField + ', `brands`);">' +
                                                '<i class="icon-cross2"></i> {general:delete}</a>' +
                                        '</div>' +
                                    '</div>' +
                                '</div>' +
                            '</td>';
                        }
                    },
                    // { data: "letters",
                    //     render: function (dataField) {
                    //         return  '<td><b>' + dataField + '</b></td>';
                    //     }
                    // }
                ],
                columnDefs: [
                    { width: '5%',      targets: 0, className: "move_zone text-center"},
                    { orderable: false, targets: 1, width: '200', className: "text-center" },
                    { width: '40%',     targets: 2 },
                    { width: '20%',     targets: 3, className: "text-center"},
                    { orderable: false, targets: 4, width: '8%', className: "text-center" },
                   // { visible: false,   targets: 5 , orderable: false,}
                ],
                order: [[0, 'asc']],
                dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
                language: { "url": "{$GLOBAL_URL}/admin/assets/js/plugins/tables/datatables/lang/{$config.admin_language}.json" },
                lengthMenu: [10, 25, 50, 75, 100],
                displayLength: 10,
                drawCallback: function (settings) {
                    var api = this.api();
                    var rows = api.rows({ page: 'current' }).nodes();

                    // var last = null;
                    // api.column(5, { page: 'current' }).data().each(function (group, i) {
                    //     if (last !== group) {
                    //         $(rows).eq(i).before('<tr class="table-active table-border-double"><td colspan="5" class="font-weight-semibold"><b>' + group + '</b></td></tr>');
                    //         last = group;
                    //     }
                    // });

                }
            });

            var table = $('.brands-archive').DataTable({ });
            // var table = $('.brands-archive').DataTable({
            //    // colReorder: true,
            //     fixedHeader: {
            //         headerOffset: 48,
            //         header: true
            //     },
            //     // rowReorder: {
            //     //     dataSrc: 'brandId',
            //     // },
            //     select: true,
            // });

            // // Setup event
            // table.on('row-reorder', function (e, diff, edit) {
            //     // console.log(e);
            //      console.log(diff);
            //     console.log(edit);
            //
            //     var result = 'Reorder started on row: '+edit.triggerRow.data()[1]+'<br>';
            //
            //     for (var i=0, ien=diff.length ; i<ien ; i++) {
            //         var rowData = table.row( diff[i].node ).data();
            //
            //         result += rowData[1]+' updated to be in position '+
            //             diff[i].newData+' (was '+diff[i].oldData+')<br>';
            //     }
            //
            //     $('#event-result').html('Результат:<br>'+result);
            // });




            // // ColReorder integration
            // var table_reorder = $('.brands-archive').DataTable({
            //     fixedHeader: true,
            //     colReorder: true
            // });
            //
            //
            // // Adjust table header if sidebar toggler is clicked
            // $('.sidebar-control').on('click', function() {
            //     table_basic.fixedHeader.adjust();
            //     table_footer.fixedHeader.adjust();
            //     table_offset.fixedHeader.adjust();
            //     table_reorder.fixedHeader.adjust();
            // });

        };

        // Select2 for length menu styling
        var _componentSelect2 = function() {
            if (!$().select2) {
                console.warn('Warning - select2.min.js is not loaded.');
                return;
            }

            // Initialize
            $('.dataTables_length select').select2({
                minimumResultsForSearch: Infinity,
                dropdownAutoWidth: true,
                width: 'auto'
            });
        };

        return {
            init: function() {
                _componentDatatable();
                _componentSelect2();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        BrandList.init();
    });















</script>





