<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    {if isset($brand->brandId)} <input type="hidden" name="brand[brandId]" value="{$brand->brandId}" />{/if}
    
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;
                    <a class="btn btn-sm btn-light" href="index.php?mod=brands&page={if isset($page)}{$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="index.php?mod=brands" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
                                    <input type="text" class="form-control" id="name" autocomplete="off" name="brand[name]" value="{if isset($brand->name)}{$brand->name}{/if}" onblur="proposeFileName('name', 'fileName', 'brand', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="brand[fileName]" value="{if isset($brand->fileName)}{$brand->fileName}{/if}" />
                                </div>
            			    </div>
                        </div> 
                    </div>
    		    </div>

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:description}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>
                    <div class="card-body flex-column flex-md-row m-0 p-0">
        			    <ul class="nav nav-tabs nav-tabs-top mb-0" style="border-bottom: 0px solid #ddd;">
        				    <li class="nav-item"><a href="#summary" class="nav-link active show" data-toggle="tab">{general:tabs:summary}</a></li>
                            <li class="nav-item"><a href="#content" class="nav-link" data-toggle="tab">{general:tabs:content}</a></li>
        			    </ul>
        
                        <div class="tab-content border-top-0 rounded-top-0 mb-0">
        				    <div class="tab-pane fade show active" id="summary">
        					    <textarea name="brand[summary]" class="description">{if isset($brand->summary)}{$brand->summary}{/if}</textarea>
        				    </div>
        
                            <div class="tab-pane fade" id="content">
        					    <textarea name="brand[content]" class="description">{if isset($brand->content)}{$brand->content}{/if}</textarea>
        				    </div>
        				</div>
    			    </div>
    		    </div>
    
                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>	&nbsp;
                    <a class="btn btn-sm btn-light" href="index.php?mod=brands&page={if isset($page)}{$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{general:cancel}</a>
                </div>
            
            </div>
    
    
            <div class="col-md-4">
        		<div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
    				<div class="card-body border-top-0">
    					<figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses name="brand[status]" id="status" selected=$brand->status|default:'visible' class="form-control select"}
                            </div>
                        </figure>

                        <figure>
                            {if isset($brand->addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$brand->addedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand->addedBy->loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                            {if isset($brand->modifiedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:modified}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$brand->modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$brand->modifiedBy->loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                        </figure>
                        
    				</div>
    			</div>
    			
                <div class="card">
    				<div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:addImage}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
                    <div class="card-body">
                        <div class="content-image gallery">
                            {if isset($brand->image)}
                                <div class="gallery-item item-{$brand->brandId}" id="image_general">
                                    <div class="image" id="image-{$brand->brandId}">
                                        <img src="{$brand->image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$brand->brandId}, 'brand');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>

                                </div>
                            {/if}
                        </div>

                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>

    			</div>
    
    			<div class="card card-collapsed">
    			    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:card:seo}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>
    
        			<div class="card-body flex-column flex-md-row m-0">
        				<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:metaTitle}</label>
                            <input class="form-control" autocomplete="off" id="meta_title" type="text" name="brand[meta_title]" value="{if isset($brand->meta_title)}{$brand->meta_title}{/if}"/>
                        </div>
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:keywords}</label>
                            <textarea id="keywords" name="brand[keywords]" class="form-control" rows="3">{if isset($brand->keywords)}{$brand->keywords}{/if}</textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:description}</label>
                            <textarea id="description" name="brand[description]" class="form-control" rows="3">{if isset($brand->description)}{$brand->description}{/if}</textarea>
                        </div>
        			</div>
        		</div>
    
            </div>
    
        </div>

    </div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}


    {if isset($errors.access_denied)}<span id="accessDeniedError" onclick="new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.title)}<span id="titleError" onclick="new Noty({ text: '{brands:errors:1}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.not_saved)}<span id="notSavedError" onclick="new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.no_sections)}<span id="noSectionsError" onclick="new Noty({ text: '{brands:errors:4}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.image_not_saved)}<span id="imageNotSavedError" onclick="new Noty({ text: '{brands:errors:5}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.article_not_found)}<span id="articleNotFoundError" onclick="new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.fileName)}<span id="fileNameError" onclick="new Noty({ text: '{brands:errors:7}', type: 'error', timeout: 3000 }).show();"></span>{/if}
	{if isset($errors.fileNameExists)}<span id="fileNameExistsError" onclick="new Noty({ text: '{brands:errors:8}', type: 'error', timeout: 1500 }).show();"></span>{/if}
	<script>
  	
    $(document).ready(function () {
      
      {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 3000 }).show(); {/if}
      {if isset($errors.title)} new Noty({ text: '{brands:errors:1}', type: 'error', timeout: 3000 }).show(); {/if}
      {if isset($errors.not_saved)} new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.image_not_saved)} new Noty({ text: '{brands:errors:5}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 3000 }).show();{/if}
      {if isset($errors.fileName)} new Noty({ text: '{brands:errors:7}', type: 'error', timeout: 3000 }).show();;{/if}
      {if isset($errors.fileNameExists)} new Noty({ text: '{brands:errors:8}', type: 'error', timeout: 1500 }).show(); {/if}

      {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show();{/if}

      
    });
    function deleteImageSuccess(){
        new Noty({ text: '{brands:messages:1}', type: 'success', timeout: 1500 }).show();
        document.getElementById('image_general').style.display = 'none';
    }
    function deleteMessage(){
        new Noty({ text: '{brands:messages:2}', type: 'success', timeout: 1500 }).show();
    }
    function deleteImageError(){ new Noty({ text: '{sections:errors:14}', type: 'error', timeout: 3000 }).show(); }

    function successImageMessage(){ new Noty({ text: '{sections:messages:10}', type: 'success', timeout: 1500 }).show(); }
    

    $(function () {
        function e() { meta_title_touched || $("#meta_title").val(m()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function m() { return name = $("#name").val() }
        function i() { return name = $("#name").val() }
        function t() { return name = $("#name").val() }
        function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        meta_title_touched = !0, 
        keywords_touched = !0, 
        description_touched = !0, 
        fileName_touched = !0, 
        ($("#meta_title").val() == i() || "" == $("#meta_title").val()) && (meta_title_touched = !1), 
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1), 
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1), 
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1), 
        $("#meta_title").change(function () { meta_title_touched = !0 }),
        $("#keywords").change(function () { keywords_touched = !0 }),
        $("#description").change(function () { description_touched = !0 }),
        $("#fileName").change(function () { fileName_touched = !0 }),
        $("#name").keyup(function () { e() })
    });




    </script>
