<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">
			    <a class="btn btn-sm btn-light" href="index.php?mod=botmymailings&page={if isset($page)}{$page}{/if}{if isset($status)}&status={$status}{/if}">Назад</a>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="index.php?mod=botmymailings" class="breadcrumb-item">{$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center">
			    </div>
    		</div>
    	</div>
    </div>

    <div class="content">

        <div class="row"> 
            <div class="col-md-8">

    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
			        <div class="card-body">
				        <div class="row">
					        <div class="col-md-12">
						        {if isset($mailing->status)}
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Статус:

                                        {if $mailing->status eq 'visible'}
	                                        <span class="badge badge-secondary badge-pill">{if isset($mailing->statusName)}{$mailing->statusName}{/if}</span>
								        {else}
	                                        <span class="badge badge-success badge-pill">{if isset($mailing->statusName)}{$mailing->statusName}{/if}</span>
								        {/if}
							        </label>
						        </div>
						        {/if}
					        </div>
				        </div>
				        <div class="row">
					        <div class="col-md-12">
						        <table class="table table-xs table-xstable-togglable table-striped table-hover">
							        <thead>
							        <tr>
								        <th data-hide="ID" class="text-center" width="30"></th>
								        <th data-hide="phone" class="text-center">Контактов</th>
{*								        <th data-hide="image" class="text-center">Сообщений</th>*}
							        </tr>
							        </thead>
							        <tbody class="selectable-demo-list">
								        <tr>
									        <td class="text-nowrap">Получателей</td>
									        <td class="text-nowrap text-center">{$total}</td>
								        </tr>
								        <tr>
									        <td class="text-nowrap">Отклонено</td>
									        <td class="text-nowrap text-center">{$totalError}</td>
								        </tr>
								        <tr>
									        <td class="text-nowrap">Отправлено</td>
									        <td class="text-nowrap text-center">{$totalSend}</td>
								        </tr>
								        <tr>
									        <td class="text-nowrap">Доставлено</td>
									        <td class="text-nowrap text-center">{$totalDelivered}</td>
								        </tr>

							        </tbody>
						        </table>
					        </div>
				        </div>
			        </div>
    		    </div>
            </div>
    
    
            <div class="col-md-4">

	            <div class="card card-collapsed">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">Шаблон рассылки</h6>
			            <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
		            </div>
		            {if $mailing->positionImage eq 2}
	                    {if isset($mailing->image)}
				            <div class="card-img-actions" style="height: auto;">
					            <img class="card-img-top img-fluid" src="{$mailing->image->medium}" alt="">
				            </div>
	                    {/if}
		            {/if}
		            <div class="card-body">
			            <p class="card-text">{if isset($mailing->content)}{$mailing->content nofilter}{/if}</p>
		            </div>
                    {if $mailing->positionImage eq 1}
                        {if isset($mailing->image)}
				            <div class="card-img-actions" style="height: auto;">
					            <img class="card-img-top img-fluid" src="{$mailing->image->medium}" alt="">
				            </div>
                        {/if}
                    {/if}
	            </div>
            </div>

	        <div class="col-md-12">
		        <div class="card">
			        <table class="table table-togglable table-xs table-striped table-hover users-archive" id="users">
				        <thead>
				        <tr>
					        <th data-hide="ID" class="text-center text-nowrap" width="30">user id</th>
					        <th data-hide="image" class="">chat id</th>
					        <th data-hide="image" class="">username</th>
					        <th data-hide="image" class="">fullName</th>
					        <th data-hide="phone" class="text-center">status</th>
					        <th data-hide="phone" class="text-center">state</th>
					        <th data-hide="phone" class="text-center">Сообщение</th>
				        </tr>
				        </thead>
			        </table>
		        </div>
	        </div>
        </div>
    </div>
</form>


<script>

    $(document).ready(function () {
        {if isset($errors.template_empty)} new Noty({ text: 'Шаблон рассылки не найдет', type: 'error', timeout: 2500 }).show(); {/if}
    });

    var BrandList = function() {

        // Datatable
        var _componentDatatable = function() {
            if (!$().DataTable) {
                console.warn('Warning - datatables.min.js is not loaded.');
                return;
            }

            $.extend( $.fn.dataTable.defaults, {
                autoWidth: false,
                processing: true,
                serverSide: true,
                deferRender: true,
                stateSave: true,
                ajax: {
                    "url": "index.php?mod=botmailingstats&action=table&id={if isset($mailing->id)}{$mailing->id}{/if}",
                    "type": 'POST',
                    dataSrc: "data",
                },
                'createdRow': function( row, data, dataIndex ) {
                    $(row).attr("data-id", data.id).attr("id", 'manager-' + data.id);
                },
                columns: [
                    { data: "user_id",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
                    { data: "chat_id",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
	                { data: "username",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
                    { data: "firstName",
                        render: function (dataField, type, row) {
                            if (row.lastName != null) {
                                return row.firstName + ' ' + row.lastName;
                            } else {
                                return row.firstName;
                            }
                        }
                    },
	                { data: "status",
                        render: function (dataField) {
	                        if (dataField == 200) {
                                return `<span class="badge badge-success badge-pill">` + dataField + `</span>`;
                            } else {
                                return `<span class="badge badge-warning badge-pill">` + dataField + `</span>`;
                            }
                        }
                    },
	                { data: "state",
                        render: function (dataField) {
	                        if (dataField == 'OK') {
                                return `<span class="badge badge-success badge-pill">` + dataField + `</span>`;
                            } else {
                                return `<span class="badge badge-warning badge-pill">` + dataField + `</span>`;
                            }
                        }
                    },
                    { data: "message",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    }
                ],
                columnDefs: [
                    { width: '5%',  targets: 0, className: "text-nowrap"},
                    { width: '10%', targets: 1, className: "text-nowrap" },
                    { width: '10%', targets: 2, className: "text-nowrap" },
                    { width: '20%', targets: 3, className: "text-nowrap" },
                    { width: '5%',  targets: 4, className: "text-nowrap text-center" },
                    { width: '5%',  targets: 5, className: "text-nowrap text-center" },
                    { width: '40%', targets: 6, className: "text-nowrap" },
                ],
                order: [[0, 'asc']],
                dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
                language: { "url": "{$GLOBAL_URL}/admin/assets/js/plugins/tables/datatables/lang/{$config.admin_language}.json" },
                lengthMenu: [10, 25, 50, 75, 100],
                displayLength: 10,
                drawCallback: function (settings) {
                    var api = this.api();
                    var rows = api.rows({ page: 'current' }).nodes();
                }
            });

            var table = $('.users-archive').DataTable({ });

        };

        return {
            init: function() {
                _componentDatatable();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        BrandList.init();
    });


</script>
