<form method="post" enctype="multipart/form-data" class="form-content-wrapper">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">

    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="index.php?mod=botmymailings" class="breadcrumb-item">{$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">

        <div class="row"> 
            <div class="col-md-8">

    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
			        <div class="card-body">
				        <div class="row">
					        <div class="col-md-12">
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Подписчиков: <span id="sendTo" class="badge badge-success badge-pill">0</span> из <span class="badge badge-secondary badge-pill">{$total}</span></label>
                                    {*								<label class="form-group-float-label is-visible">Подписчиков: <span id="sendTo">0</span> из <span class="badge badge-secondary badge-pill">{$total} {$total|plural:'человек':'человек':'человека'}</span></label>*}
						        </div>
					        </div>
				        </div>
				        <div class="row">
					        <div class="col-md-12">
						        <div class="progress mb-3">
							        <div class="progress-bar bg-success" style="width: 0%">
								        <span >0% Complete</span>
							        </div>
						        </div>
					        </div>
					        <div class="col-md-4">
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Начать рассылку с: <span id="gesendet"></span></label>
							        <input type="text" class="form-control" id="startFrom" autocomplete="off" name="startFrom" value="0">
							        <i>пользователя (введите 0, если хотите начать рассылку с самого начала)</i>
						        </div>
					        </div>
					        <div class="col-md-4">
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Кол-во за один проход:</label>
							        <input  type="text" class="form-control" id="limit" autocomplete="off" name="limit" value="1" />
						        </div>
					        </div>
					        <div class="col-md-4">
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Интервал в секундах между отправкой:</label>
							        <input  type="text" class="form-control" id="interval" autocomplete="off" name="interval" value="1"/>
						        </div>
					        </div>

					        <div class="col-md-12">
						        <div class="form-group form-group-float">
							        <label class="form-group-float-label is-visible">Тестовые chat ID</label>
							        <input  type="text" class="form-control" id="chats" autocomplete="off" name="chats" value="" placeholder="Пример: 12312524, 1233453109"/>
							        <i>Указать CHAT ID через запятую если оправлять нескольким. Например: 12312524, 1233453109</i>
						        </div>
					        </div>
				        </div>
			        </div>
    		    </div>
    

    
                <div class="col-md-12 main main_buttons text-center">
	                <a href="javascript:void('');" class="btn btn-sm btn-primary testing">&nbsp; Тестовая рассылка &nbsp;</a> &nbsp;
	                <button class="btn btn-sm btn-primary" id="subscribe_send" type="button">&nbsp; Разослать &nbsp;</button> &nbsp;
                    <a class="btn btn-sm btn-light" href="index.php?mod=botmymailings&page={if isset($page)}{$page}{/if}{if isset($status)}&status={$status}{/if}">{general:cancel}</a>
                </div>
            
            </div>
    
    
            <div class="col-md-4">
	            <div class="card">
		            {if isset($mailing->positionImage) && $mailing->positionImage eq 2}
			            {if isset($mailing->image)}
				            <div class="card-img-actions" style="height: auto;">
					            <img class="card-img-top img-fluid" src="{$mailing->image->medium}" alt="">
				            </div>
			            {/if}
		            {/if}
		            <div class="card-body">
			            <p class="card-text">{if isset($mailing->content)}{$mailing->content nofilter}{/if}</p>
		            </div>
		            {if isset($mailing->positionImage) &&  $mailing->positionImage eq 1}
			            {if isset($mailing->image)}
				            <div class="card-img-actions" style="height: auto;">
					            <img class="card-img-top img-fluid" src="{$mailing->image->medium}" alt="">
				            </div>
			            {/if}
		            {/if}
	            </div>
            </div>
        </div>

    </div>
</form>


<script>

    $(document).ready(function () {
        {if isset($errors.template_empty)} new Noty({ text: 'Шаблон рассылки не найдет', type: 'error', timeout: 2500 }).show(); {/if}
    });

    var total = {$total};

    $(function() {
        var subscribeButton = $('#subscribe_send');

        subscribeButton.on('click', function() {
            $('#status').html('отправка ...');
            subscribeButton.attr("disabled", true).text("Продолжить отправку");

            senden( $('#startFrom').val() );
            return false;
        });

        if(total == 0) {
            $('#subscribe_send').attr("disabled", "disabled");
        }


        $("#status").ajaxError(function(event, request, settings) {
            $(this).html('<span class="badge badge-danger">ошибка отправки</span>');
            subscribeButton.attr("disabled", false);
            var limit = $('#limit').val();
            var startAgain = parseInt($('#startFrom').val());
            startAgain = startAgain + limit;

            $('#startFrom').val( startAgain );
        });
    });

    // function subscribe_send() {
    //     $('#status').html('отправка ...');
    //     $('#subscribe_send').attr("disabled", true).text("Продолжить отправку");
    //
    //     senden( $('#startFrom').val() );
    //     return false;
    // }

    function senden(startFrom) {
        var subscribeButton = $('#subscribe_send'), limit = $('#limit').val(), interval = $('#interval').val();

        interval = (interval * 1000);

        $.post("index.php?mod=botmailingsend", { action: "send", id: {if isset($mailing->id)}{$mailing->id}{else}0{/if}, startFrom: startFrom, limit: limit }, function (data) {

            $('#gesendet').text(data.count);
            $('#startFrom').val(data.count);
            $('#sendTo').text(data.count);

            var percent = Math.round((100 * data.count) / total);
            if (percent > 100) percent = 100;

            $('.progress-bar').width(percent + '%');
            $('.progress-bar span').text(percent + '% Complete');

            // if (data.status === 200) {
                if (data.count >= total) {
                    $('#status').html('<span class="badge badge-success">отправка завершена</span>');
                    subscribeButton.attr("disabled", false).text("Отправка завершена");
                    $.post("index.php?mod=botmailingsend", { action: "end", id: {if isset($mailing->id)}{$mailing->id}{else}0{/if} }, function (data) {
                        console.log(data)
                    });
                } else {
                    setTimeout("senden(" + data.count + ")", interval );
                }
            // }
	        if (data.group) {
                new Noty({ text: data.message + '<br /><br />' + data.group, type: data.type, timeout: 2500 }).show();
            } else {
                new Noty({ text: data.message, type: data.type, timeout: 2500 }).show();
            }

        }, "json").fail(function(jqXHR, textStatus, errorThrown ) {

            var error_status = '', startAgain = parseInt($('#startFrom').val());
            startAgain = startAgain + {$limit};

            if (jqXHR.status < 200 || jqXHR.status >= 300) {
                error_status = 'HTTP Error: ' + jqXHR.status;
            } else {
                error_status = 'Invalid JSON: ' + jqXHR.responseText;
            }

            $('#startFrom').val(startAgain);
            $('#status').html('<span class="badge badge-danger">ошибка отправки</span>');
            subscribeButton.attr("disabled", false);

            new Noty({ text:  error_status, type: 'error', timeout: 2500 }).show();
        });

        return false;
    }


    $(document).on('click', '.testing', function(e) {
        var chats = $('#chats').val();

        // new Noty({ text: "Примерное время выполнения скрипта: " + parseInt((total / 60 * 1.5)) + " минут(ы)" + ", пользователей (" + total + "). !!!<br> Дождитесь завершения процесса !!!", type: 'info', timeout: 5000 }).show();
        $.post("index.php?mod=botmailingsend", { action: "testing", id: {if isset($mailing->id)}{$mailing->id}{else}0{/if}, chatIDS: chats }, function(data) {
            new Noty({ text: data.message, type: data.type, timeout: 1500 }).show();
        }, "json");

    });

    $(document).on('click', '.change_status', function(e) {
        $.post("index.php?mod=botmailingsend", { action: "change" }, function(data) {
            if (data.status === 200) {
                new Noty({ text: 'Статусы успешно обновлены! <br> у ' + data.count + ' пользователей', type: 'success', timeout: 1500 }).show();
                setTimeout(window.location.reload(), 1500);
                // window.location.reload();
            } else {
                new Noty({ text: 'Ошибка изменения статуса!', type: 'error', timeout: 1500 }).show();
            }
        }, "json");
    });
</script>
