{assign var=wrapper value="" scope=global}
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{login:title} - {productName}</title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="/admin/assets/js/main/jquery.min.js"></script>
	<script src="/admin/assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="/admin/assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="/admin/assets/js/plugins/ui/ripple.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="/admin/assets/js/plugins/forms/styling/uniform.min.js"></script>
{*	<script src="/admin/assets/js/plugins/forms/styling/switchery.min.js"></script>*}
{*	<script src="/admin/assets/js/plugins/forms/styling/switch.min.js"></script>*}
{*	<script src="/admin/assets/js/plugins/forms/tags/tagsinput.min.js"></script>*}
{*	<script src="/admin/assets/js/plugins/media/fancybox.min.js"></script>*}
{*	<script src="/admin/assets/js/plugins/forms/tags/tokenfield.min.js"></script>*}

	<script src="assets/js/app.js"></script>
	<script src="/admin/assets/js/demo_pages/login.js"></script>
	<!-- /theme JS files -->

</head>

<body>
	<div class="page-content login-cover">
		<div class="content-wrapper">
			<div class="content d-flex justify-content-center align-items-center">
				<!-- Unlock form -->
				<form class="login-form" action="index.php?mod=auth" id="login" accept-charset={$config.charset}>
					<div class="card mb-0">
						<div class="card-body">
							<div class="text-center">
								<div class="card-img-actions d-inline-block mb-3">
									<img class="rounded-circle" src="/images/demo/users/face11.jpg" width="160" height="160" alt="">
									<div class="card-img-actions-overlay card-img rounded-circle">
										<a href="#" class="btn btn-outline bg-white text-white border-white border-2 btn-icon rounded-round">
											<i class="icon-question7"></i>
										</a>
									</div>
								</div>
							</div>
							{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}
								<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>
							{else}
								{if isset($errors)}
									{if isset($message_limit)}
										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit}</div>
									{else}
										{if isset($errors)}
											{foreach from=$errors item=error key=key}
												{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}
											{/foreach}
										{/if}
									{/if}
								{/if}
								{if isset($limit_cnt)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} попыт{$limit_cnt|plural:'ка':'ок':'ки'}</div>
								{/if}
								{if isset($isBanned)}
									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>
								{else}
									<div class="text-center mb-3">
										<h6 class="font-weight-semibold mb-0">{if isset($smarty.session) && !empty($smarty.session)}{$smarty.session.auth_username}{/if}</h6>
										<span class="d-block text-muted">Unlock your account</span>
									</div>

									<div class="form-group form-group-feedback form-group-feedback-left {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">
										<input type="password" class="form-control" id="adpass" type="password" name="login[password]" placeholder="{login:password}" autocomplete="on">
										<div class="form-control-feedback">
											<i class="icon-lock2 text-muted"></i>
										</div>
									</div>

									<div class="form-group d-flex align-items-center">
										<div class="form-check mb-0">
											<label class="form-check-label">
												<input type="checkbox" name="login[remember]" class="form-input-styled remember_check" checked data-fouc> Запомнить меня
											</label>
										</div>
										<a href="#" class="ml-auto">Forgot password?</a>
									</div>

									<button type="submit" class="btn btn-primary btn-block"><i class="icon-unlocked mr-2"></i> Unlock</button>
								{/if}
							{/if}
						</div>
					</div>
				</form>
				<!-- /unlock form -->

{*				<form class="login-form" method="post" action="index.php?mod=auth" id="login" accept-charset={$config.charset}>*}
{*					<div class="card mb-0">*}
{*						<div class="card-body">*}
{*							<div class="text-center mb-3">*}
{*								<i class="icon-reading icon-2x text-slate-300 border-slate-300 border-3 rounded-round p-3 mb-3 mt-1"></i>*}
{*								<h5 class="mb-0">Login to your account</h5>*}
{*								<span class="d-block text-muted">Your credentials</span>*}
{*							</div>*}
{*							{if isset($IS_BANNED_USER) && !empty($IS_BANNED_USER)}*}
{*								<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$IS_BANNED_USER}</div>*}
{*							{else}*}
{*								{if isset($errors)}*}
{*									{if isset($message_limit)}*}
{*										<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$message_limit}</div>*}
{*									{else}*}
{*										{if isset($errors)}*}
{*											{foreach from=$errors item=error key=key}*}
{*												{if !empty($error)}<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">{$error}</div>{/if}*}
{*											{/foreach}*}
{*										{/if}*}
{*									{/if}*}
{*								{/if}*}
{*								{if isset($limit_cnt)}*}
{*									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Осталось {$limit_cnt} попыт{$limit_cnt|plural:'ка':'ок':'ки'}</div>*}
{*								{/if}*}
{*								{if isset($isBanned)}*}
{*									<div class="alert alert-danger" role="alert" style="position: relative;margin-bottom: 10px;">Вы исчерпали количество попыток на сегодня.</div>*}
{*								{else}*}
{*									<div class="form-group form-group-feedback form-group-feedback-left {if isset($errors.enter_username)}error{/if}">*}
{*										<input type="text" class="form-control" id="adlogin" name="login[loginName]" value="*}{*if isset($smarty.session) && !empty($smarty.session)}{$smarty.session.auth_username}{/if*}{*" placeholder="{login:username}" autocomplete="off">*}
{*										<div class="form-control-feedback">*}
{*											<i class="icon-user text-muted"></i>*}
{*										</div>*}
{*									</div>*}

{*									<div class="form-group form-group-feedback form-group-feedback-left {if isset($errors.enter_password) or isset($errors.wrong_username_password) or isset($errors.enter_username_password)}error{/if}">*}
{*										<input type="password" class="form-control" id="adpass" type="password" name="login[password]" placeholder="{login:password}" autocomplete="on">*}
{*										<div class="form-control-feedback">*}
{*											<i class="icon-lock2 text-muted"></i>*}
{*										</div>*}
{*									</div>*}

{*									<div class="form-group d-flex align-items-center">*}
{*										<div class="form-check mb-0">*}
{*											<label class="form-check-label">*}
{*												<input type="checkbox" name="login[remember]" class="form-input-styled remember_check" checked data-fouc> Запомнить меня*}
{*											</label>*}
{*										</div>*}
{*									</div>*}

{*									<div class="form-group">*}
{*										<button type="submit" name="action" value="login" class="btn btn-primary btn-block">{login:signIn} <i class="icon-circle-right2 ml-2"></i></button>*}
{*									</div>*}

{*								{/if}*}
{*							{/if}*}

{*							<span class="form-text text-center text-muted">*}
{*								By continuing, you're confirming that you've read our*}
{*								<a href="login_hide_navbar.html#">Terms &amp; Conditions</a> and*}
{*								<a href="login_hide_navbar.html#">Cookie Policy</a>*}
{*							</span>*}
{*						</div>*}
{*					</div>*}
{*				</form>*}
			</div>
		</div>
	</div>
	<script>
		$('.remember_check').on('change', function(){
			this.value = this.checked ? 1 : 0;
		}).change();
	</script>
</body>
</html>
