<?php

/* starting session */

use Mnv\Core\Config;
use Mnv\Admin\Controllers\IndexAdmin;
use Mnv\Core\Utilities\Cookie\Cookie;
use Mnv\Core\Utilities\Cookie\Session;

require_once '../includes/overall.inc.php';
require_once '../includes/admin-functions.inc.php';

const MNV_CMS = true;

$time_start = microtime(true);

/* header no proxy / browser cache */
$expires = time() + (60*60*24);
header("Expires: " . gmdate("D, d M Y H:i:s", $expires) . " GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Pragma: no-cache");

$adminSessionName   = 'ls-admin';
$smarty->assign('adminSessionName', $adminSessionName);

Session::start($adminSessionName);
$smarty->assign('sessionId', Session::id());
Cookie::setcookie($adminSessionName, Session::id(),time () + 3600, '/', '', '', true, 'Lax');

/* language functions */
$admin_language = Config::getValue('admin_language');
loadLanguage($admin_language);
$smarty->assign('adminLang', $admin_language);
$smarty->assign('jsLang', langJs('javascript'));
$smarty->registerFilter(Smarty::FILTER_PRE,  'replaceLanguageTags', null);

$tmpPath = sprintf('%s/temp/smarty/', GLOBAL_ROOT);
$smarty->compile_check   = Smarty::COMPILECHECK_ON;
$smarty->setCompileDir($tmpPath . 'compile');
$smarty->setCompileId('admin-' . $admin_language);
$smarty->setTemplateDir(GLOBAL_ROOT . '/admin/templates');
//$smarty->debugging = true;

$admin = new IndexAdmin();

print $admin->fetch();



// Отладочная информация
print "<!--\r\n";
$time_end = microtime(true);
$exec_time = $time_end-$time_start;
if(function_exists('memory_get_peak_usage')) {
    print "memory peak usage: ".memory_get_peak_usage()." bytes (" . (memory_get_peak_usage(true)/1024/1024)." MiB) \r\n";
    print "Memory in use: " . memory_get_usage() . " (". (sprintf("%0.2f",(memory_get_usage() / 1024) / 1024)) ."M) \r\n";
}
print "page generation time: ".$exec_time." seconds\r\n";
print "php run time: ". round($exec_time, 4) . " seconds\r\n";
print "-->";

