<?php

use Mnv\Core\Config;
use Mnv\Core\Files\FileManager;

include('../../includes/overall.inc.php');
include('../../includes/admin-functions.inc.php');

/**
 * Загрузка изображений на сервер через редактор tinymce
 * uploading-file-to-content
 */
if (isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))
{
    $file = getRequestFiles();

    if (isset($file) && !empty($file['file'])) {

        loadLanguage(Config::getValue('admin_language'));

        $fileManager = new FileManager(UPLOAD_ROOT . 'content');

        $extension = $fileManager->fileExtension($file['file']['name']);

        if (in_array($extension, $fileManager->ext_img)) {

            $result = $fileManager->fileUpload('content/', $file['file'], 0);
            if (!empty($fileManager->response['fileId']))
                $fileManager->response['link'] = $fileManager->getFileUrl($fileManager->response['fileId']);

            $fileManager->response['flink'] = '';
        } else {
            $fileManager->response = array('status' => 500, 'message' => lang('fileManager:errors:19'), 'error' =>  lang('fileManager:errors:19'));
        }
        response()->json($fileManager->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
        exit();
    }

} else {

     die('Hacking attempt!');
}
