<?php

use Mnv\Core\Config;

require_once '../../includes/overall.inc.php';


$errors = array();
$messages = array();

$action         = getRequestVar('action','');
$root_folder    = getRequestVar('root_folder','');
$dir            = getRequestVar('dir','/');
$file           = getRequestVar('file','');
$content        = getRequestVar('content', '', true);


fileTree($action, $dir, $file, $content, $root_folder);


function clear_url_dir($var)
{
    if (is_array($var))
        return "";
    $var = str_replace(chr(0), '', $var);
    $var = str_ireplace( ".php", "", $var );
    $var = str_ireplace( ".php", ".ppp", $var );
    $var = trim( strip_tags( $var ) );
    $var = str_replace( "\\", "/", $var );
    $var = preg_replace( "/[^a-z0-9\/\_\-]+/mi", "", $var );
    return $var;
}

/**
 * @param string $action
 * @param string $dir
 * @param string $file
 * @param string $content
 */
function fileTree($action = '', $dir = '/', $file = '', $content = '', $root_folder)
{

    $allowed_extensions = array("tpl", "css", "js");
    $root = GLOBAL_ROOT . "/themes/" . $root_folder;

    if (!empty($action) && $action == "upload") {

        $file = trim(str_replace("..", "", urldecode($file)));
        if (!$file) {
            die ("error");
        }
        $url = @parse_url($file);

        $file_path = isset($url['path']) ? dirname (clear_url_dir($url['path'])) : '';
        $file_name = @pathinfo($url['path'] ?? $url['host']);
        $file_name = totranslit($file_name['basename'], false, true);

        $type = explode(".", $file_name);
        $type = totranslit(end($type));

        if (!in_array($type, $allowed_extensions ))
            die ();

        if (!file_exists($root . $file_path . "/" . $file_name))
            die ();

        if (!is_writable($root . $file_path . "/" . $file_name)) {
            print 'Невозможно создать временный файл шаблона';
            die ();
        }
        if (version_compare(PHP_VERSION, '7.4.0', '<')) {
            if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) $content = stripslashes($content);
        } else {
            $content = stripslashes($content);
        }

//            print_r($root . $file_path . "/" . $file_name);

        $handle = fopen($root . $file_path . "/" . $file_name, "w");
        fwrite($handle, $content);
        fclose($handle);

        if ($type == "css" OR $type == "js") {
            $folder = opendir(GLOBAL_ROOT . '/temp/compress/');
            while ($file = readdir($folder)) {
                if ($file != '.' and $file != '..' and $file != '.htaccess') @unlinkFile(GLOBAL_ROOT . '/temp/compress/' . $file);
            }
        }
        print $messages['saved'] = true;

    }
    /** чтение файла */
    else if (!empty($action) && $action == "load") {

        $file = trim(str_replace("..", "", urldecode($file)));
        if (!$file) die ();
        $url = parse_url($file);

        $file_path  = dirname (clear_url_dir($url['path']));
        $file_name  = pathinfo($url['path']);
        $file_name  = totranslit($file_name['basename'], false, true);
        $type       = explode(".", $file_name);
        $type       = totranslit(end($type));
        if (!in_array( $type, $allowed_extensions)) die ("error");
        if (!file_exists($root.$file_path."/".$file_name)) die ("error");
        $content = htmlspecialchars(file_get_contents( $root . $file_path . "/" . $file_name), ENT_QUOTES, Config::getValue('charset') );
        echo "<p style='padding:10px 0px 0px 10px;'>Редактирование файла: <b>". $file_path."/".$file_name . "</b></p>";
        if (!is_writable($root.$file_path."/".$file_name)) echo " <span style='color:red;'>Невозможно создать временный файл шаблона</span>";

        $script= "";

        if ($type == "tpl") {
            $script= <<<HTML
      <script>
        var editor = CodeMirror.fromTextArea(document.getElementById('file_text'), {
          mode: "htmlmixed",
          lineNumbers: true,
          dragDrop: false,
          indentUnit: 4,
          indentWithTabs: false,
          extraKeys: {
            "Tab": function(cm){
              cm.replaceSelection("  " , "end");
            }
           }
        });
      </script>
HTML;
        }

        if ($type == "css") {
            $script= <<<HTML
<script>
  var editor = CodeMirror.fromTextArea(document.getElementById('file_text'), {
    indentUnit: 4,
    lineNumbers: true,
    dragDrop: false,
    mode: "css"
  });
</script>
HTML;

        }

        if ($type == "js") {
            $script= <<<HTML
    <script>
      var editor = CodeMirror.fromTextArea(document.getElementById('file_text'), {
        lineNumbers: true,
        matchBrackets: true,
        indentUnit: 4,
        dragDrop: false,
        mode: "javascript"
        });
</script>
HTML;

        }
        echo <<<HTML
<div style="border: solid 1px #BBB;width:100%;height:475px;"><textarea style="width:100%;height:475px;" name="file_text" id="file_text" wrap="off">{$content}</textarea></div>
<div style="padding:5px;">
<button type="button" class="btn btn-primary" onclick="udatefile('{$file_path}/{$file_name}')"><i class="icon-floppy-disk position-left"></i> &nbsp; Сохранить</button></div>
{$script}
HTML;

    } else {

        $dir = clear_url_dir(urldecode($dir));
        $postDir = rawurldecode($root.(isset($dir) ? $dir : null ));

        if (file_exists($postDir)) {
            $files		= scandir($postDir);
            $returnDir	= substr($postDir, strlen($root));
            natcasesort($files);

            if (count($files) > 2 ) {
                echo "<ul class='jqueryFileTree'>";
                foreach ($files as $file) {
                    if (file_exists($postDir . $file) && $file != '.' && $file != '..' && is_dir($postDir . $file)) {
                        echo "<li class=\"directory collapsed\"><a rel=\"" . htmlentities($dir . $file) . "/\">" . htmlentities($file) . "</a></li>";
                    }
                }

                foreach ($files as $file) {
                    $ext = preg_replace('/^.*\./', '', $file);
                    if (file_exists($postDir . $file) && $file != '.' && $file != '..' && !is_dir($postDir. $file)) {
                        if (in_array( $ext, $allowed_extensions)) {
                            echo "<li class='file ext_$ext'><a rel='" . htmlentities($dir . $file) . "'>" . htmlentities($file) . "</a></li>";
                        }
                    }
                }
                echo "</ul>";
            }
        }
    }
}




