<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\NotUserApproveException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;

/**
 * Class UsersAdmin
 */
class UsersAdmin extends AdminMnv
{

    public function fetch()
    {
        $siteUser = UserFactory::siteUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','users');
        $this->smarty->assign('title', lang('users:title'));

        /* statuses */
        $this->smarty->assign('statuses', lang('users:statuses'));
        $this->smarty->assign('subscribes', lang('users:subscribes'));

        /** Получаемые параметры $_GET / $_POST */
        $siteUser->userId     = (int) getRequestVar('id','');

        /* table list */
        $status         = getRequestVar('status', '');
        $start          = getRequestVar('start', 0);
        $length         = getRequestVar('length', 10);

        $draw               = getRequestVar('draw', 1);
        $search	            = getRequestVar('search', '');     // $_POST['search']['value'];
        $columnName         = getRequestVar('columns');                 // $_POST['columns'][$columnIndex]['data'];
        $columnSortOrder    = getRequestVar('order');                   // $_POST['order'][0]['dir'];
        /* end table list */


        if ($this->action == 'remove') {
            try {
                $siteUser->remove();
                $this->logger->info("Пользователь «ID-" . $siteUser->userId . "» удален.", $this->managers->manager);
                echo "removeElement(" . $siteUser->user->userId . ", 'user');\r\n";
                echo "deleteMessage();\r\n";
            } catch (CannotBeRemovedDeveloperException $e) {
                echo "notDeleteDeveloper()";
            } catch (CannotBeRemovedAdministratorException $e) {
                echo "notDeleteAdministrator()";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            }catch (UserNotDeletedException $e) {
                echo "notDeleteFound()";
            }
            exit;
        } else if ($this->action == 'approve') {
            try {
                $siteUser->approve();
                echo "document.getElementById('status-$siteUser->userId').innerHTML = 'АКТИВЕН';\r\n";
                echo  "document.getElementById('user-approve-$siteUser->userId').style.display = 'none';\r\n";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            } catch (NotUserApproveException $e) {
                echo "writeStatus('" . lang('users:errors:13') . "', 'aError');\r\n";
                echo "window.setTimeout(\"writeStatus('')\", 5000);\r\n";
            }
            exit;
        } else if ($this->action == 'table') {

            /** получение всех менеджеров */
            $siteUser->getAll($search['value'], $status, $start, $length, $columnSortOrder, $columnName, $this->managers->manager);

            /** получение кол-во менеджеров */
            $siteUser->total($search['value'], $status, $this->managers->manager);

            /** получение кол-во менеджеров при фильтрации */
            $siteUser->countTableFiltered($search['value'], $this->managers->manager);

            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => intval($siteUser->total),
                "recordsFiltered"   => intval($siteUser->totalFiltered),
                "data"              => $siteUser->users
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }


        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('users', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('users.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}




