<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramUsers;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\NotUserApproveException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;

/**
 * Class TelegramUsersAdmin
 */
class TelegramUsersAdmin extends AdminMnv
{

    public function fetch()
    {
        $botUsers = new TelegramUsers();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','botusers');
        $this->smarty->assign('title', 'Пользователи бота');

        /** Получаемые параметры $_GET / $_POST */
        $botUsers->userId     = (int) getRequestVar('id','');

        if ($this->action == 'remove') {
            if ($botUsers->remove()) {
                response()->make("deleteSuccess('" . $botUsers->userId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        } else {

            /** получение всех менеджеров */
            $botUsers->getAll();
            if (!is_null($botUsers->users)) {
                foreach ($botUsers->users as $userId => $user) {
                    $botUsers->users[$userId]->createdAt = langDate(adjustTime($user->createdAt, false, 'd.m.Y H:i'));
                    $botUsers->users[$userId]->updatedAt = langDate(adjustTime($user->updatedAt, false, 'd.m.Y H:i'));
                }
            }

            /** получение кол-во менеджеров */
            $botUsers->total();

            /** pagination */
            $pages = getPageNums($botUsers->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('users', $botUsers->users);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }


        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('botusers', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.users.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}




