<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\NotUpdateUserException;

/**
 * Class UsersAdmin
 */
class UserAdmin extends AdminMnv
{

    protected $user;
    protected $userId;
    protected $subscribe;
    protected $accessLevels;
    protected $image;


    public function fetch()
    {
        $siteUser = UserFactory::siteUser();

        /* Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','users');
        $this->smarty->assign('title', lang('users:title'));

        $this->smarty->assign('subscribes', lang('users:subscribes'));
        $this->smarty->assign('genders', lang('users:genders'));

        /** statuses */
        $this->smarty->assign('statuses', lang('users:statuses'));
        $this->smarty->assign('subscribes', array_slice(lang('users:subscribes'), 0));

        /** Получаемые параметры $_GET / $_POST */
        $siteUser->user    = (object)getRequestVar('user', '',  true);
        $siteUser->userId  = (int) getRequestVar('id','');
        $image             = getRequestVar('image', '', true);

        if ($this->action == 'add' || $this->action == 'edit') {
            try {
                $siteUser->edit();
                if (isset($siteUser->user)) $siteUser->user->password = '';
            } catch (NoUserException $e) {
                $this->errors['user_not_found'] = true;
            }
        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($siteUser->user->loginName)) $this->errors['login'] = true;
            if (!empty($siteUser->user->loginName) && @!preg_match('^[0-9A-Za-z_]+$^', $siteUser->user->loginName)) $this->errors['login_correct'] = true;

//                if (empty($users->user->fullName)) $this->errors['firstName'] = true;
            if (empty($siteUser->user->firstName)) $this->errors['firstName'] = true;
            if (empty($siteUser->user->lastName)) $this->errors['lastName'] = true;

//            if (empty($siteUser->user->phone)) $this->errors['phone'] = true;
            // if (!empty($siteUser->user->phone) && @!preg_match('/^[0-9]{7,15}+$/', $siteUser->user->phone)) $this->errors['phone_correct'] = true;

//            if (!empty($siteUser->user->phone) && (
//                preg_match( '/\d?(\s?|-?|\+?|\.?)((\(\d{1,4}\))|(\d{1,3})|\s?)(\s?|-?|\.?)((\(\d{1,3}\))|(\d{1,3})|\s?)(\s?|-?|\.?)((\(\d{1,3}\))|(\d{1,3})|\s?)(\s?|-?|\.?)\d{3}(-|\.|\s)\d{4}/', $siteUser->user->phone )
//                || preg_match('/([0-9]{8,13})/', str_replace(' ', '', $siteUser->user->phone))
//                || ( preg_match('/^\+?\d+$/', $siteUser->user->phone) && strlen($siteUser->user->phone) >= 8 && strlen($siteUser->user->phone) <= 13 ) )) $this->errors['phone_correct'] = true;
//

                if (empty($siteUser->user->email)) {
                    $this->errors['email1'] = true;
                } elseif (!isValidEmail($siteUser->user->email)) {
                    $this->errors['email_correct'] = true;
                }
                if (!empty($siteUser->userId)) {
                    if ($email = $siteUser->getEmailUser($siteUser->userId)) {
                        if ($email == $siteUser->user->email) {
                            $check = false;
                        } else {
                            $check = true;
                        }
                    } else {
                        $check = true;
                    }
                    if (!$check) {
                        if ($siteUser->checkEmailUser($siteUser->user->email)) $this->errors['email2'] = true;
                    }
                }

                if (empty($siteUser->userId)) if (empty($siteUser->user->password)) $this->errors['password'] = true;

                if (!empty($image)) $siteUser->user->fileId = $image['fileId'];

                if (empty($this->errors)) {
                    if (empty($siteUser->userId)) {
                        if ($siteUser->add($siteUser->user, $this->managers->manager)) {
                            $this->messages['saved'] = true;
                            $this->logger->info("Добавлен новый пользователь сайта «" . $siteUser->user->loginName . "»", $this->managers->manager);
                            if ($this->action == 'apply') redirect("index.php?mod=user&action=edit&id={$siteUser->userId}&page={$this->page}");
                        } else {
                            $this->errors['not_saved'] = true;
                            $this->logger->error("Пользователь «" . $siteUser->user->loginName . "» не сохранен", $this->managers->manager);
                        }

                    } else {
                        try {
                            $siteUser->update($siteUser->user, $this->managers->manager);
                            $this->messages['saved'] = true;
                            $this->logger->info("Пользователь «" . $siteUser->user->loginName . "» отредактирован", $this->managers->manager);
                        } catch (NotUpdateUserException $e) {
                            $this->errors['not_saved'] = true;
                            $this->logger->error("Пользователь «" . $siteUser->user->loginName . "» не сохранен", $this->managers->manager);
                        }

                        try {
                            $siteUser->edit();
                            if (isset($siteUser->user)) $siteUser->user->password = '';
                        } catch (NoUserException $e) {
                            $this->errors['user_not_found'] = true;
                        }
                    }

                    if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=users&page={$this->page}");

                }
        } else if ($this->action == 'deleteImage') {
            if ($siteUser->removeUserImage()) {
                response()->make("deleteImageMessage();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

            exit;
        }

        if (!($siteUser->user instanceof stdClass)) $siteUser->user = (object)$siteUser->user;

        $this->smarty->assign('user', $siteUser->user);

        /* Вывод сообщений или ошибок */
        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('users', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('user.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }


}




