<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramReviews;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;

/**
 * Class TelegramReviewsAdmin
 */
class TelegramReviewsAdmin extends AdminMnv
{

    public function fetch()
    {
        $botUsers = new TelegramReviews();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','botreviews');
        $this->smarty->assign('title', 'Отзывы пользователей бота');

        /* statuses */
        $this->smarty->assign('statuses', lang('users:statuses'));

        /** Получаемые параметры $_GET / $_POST */
        $botUsers->review_id     = (int) getRequestVar('id','');

        if ($this->action == 'remove') {
            try {
                $botUsers->remove();
                echo "removeElement(" . $botUsers->review_id . ", 'user');\r\n";
                echo "deleteMessage();\r\n";
            } catch (CannotBeRemovedDeveloperException $e) {
                echo "notDeleteDeveloper()";
            } catch (CannotBeRemovedAdministratorException $e) {
                echo "notDeleteAdministrator()";
            } catch (EmptyUserIdException | NoUserException $e) {
                echo "userNotFound()";
            }catch (UserNotDeletedException $e) {
                echo "notDeleteFound()";
            }
            exit;
        } else {

            /** получение всех менеджеров */
            $botUsers->getAll();
//            print_r($botUsers->reviews);
            if (!is_null($botUsers->reviews)) {
                foreach ($botUsers->reviews as $userId => $user) {
                    $botUsers->reviews[$userId]->createdAt = langDate(adjustTime($user->createdAt, false, 'd.m.Y H:i:s'));
                }
            }

            /** получение кол-во менеджеров */
            $botUsers->total();

            /** pagination */
            $pages = getPageNums($botUsers->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('users', $botUsers->reviews);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }


        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('botreviews', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.reviews.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}




