<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramMyMailings;

/**
 * Class TelegramMyMailingsAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramMyMailingsAdmin  extends AdminMnv
{

    private $statuses = array('hidden' => 'Завершена', 'visible' => 'Ожидает');

    public function fetch()
    {

        $mailings = new TelegramMyMailings();
        $this->smarty->assign('activeItem','botmymailings');
        $this->smarty->assign('title', "Шаблоны рассылки");
        /** statuses */
        $this->smarty->assign('statuses', array('hidden' => 'Завершена', 'visible' => 'Ожидает'));

        $mailings->mailingId  = getRequestVar('id', '');
        $mailings->mailing  = (object)getRequestVar('mailing', '', true);

        if ($this->action == 'remove') {

            if ($mailings->remove()) {
                response()->make("deleteSuccess('". $mailings->mailingId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'status') {

            $result = $mailings->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }

        $mailings->getAll();
        if (!empty($mailings->mailings)) {
            foreach ($mailings->mailings as $mailingId => $mailing) {
                $mailings->mailings[$mailingId]->statusName  = $this->statuses[$mailing->status]; // lang('general:statuses:' . $mailing->status);
                $mailings->mailings[$mailingId]->addedOn = langDate(adjustTime($mailing->addedOn, false, 'd.m.Y'));
                if (!empty($mailing->fileId) && $mailing->fileId > 0) $mailings->mailings[$mailingId]->image = $mailings->get_image($mailing->fileId);
            }
        }

        $mailings->total();

        $pages = getPageNums($mailings->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $mailings->total);
        $this->smarty->assign('mailings',  $mailings->mailings);
        $this->smarty->assign('pageNums', $pages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('botmymailings', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.mymailings.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

}