<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramConfig;
use Mnv\Models\Telegram\TelegramMyMailings;
use Mnv\Modules\Telegram\Telegram;

/**
 * Class TelegramMyMailingStatsAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramMyMailingStatsAdmin  extends AdminMnv
{
    private $statuses = array('hidden' => 'Завершена', 'visible' => 'Ожидает');
    private $tags = ['</p>', '<br />', '<br>', '<hr />', '<hr>', '</h1>', '</h2>', '</h3>', '</h4>', '</h5>', '</h6>', '</ul>', '</ol>', '</li>'];
    private int $step = 0;
    private int $state = 200;

    public function fetch()
    {

        $mailing = new TelegramMyMailings();

        $this->smarty->assign('activeItem','botmymailings');
        $this->smarty->assign('title', "Статистика шаблона рассылки");
        /** statuses */
        $this->smarty->assign('statuses', array('hidden' => 'Завершена', 'visible' => 'Ожидает'));

        $mailing->mailingId = (int) getRequestVar('id', '');
        /* table list */
        $status         = getRequestVar('status', '');
        $start          = getRequestVar('start', 0);
        $length         = getRequestVar('length', 10);

        $draw               = getRequestVar('draw', 1);
        $search	            = getRequestVar('search', '');     // $_POST['search']['value'];
        $columnName         = getRequestVar('columns');                 // $_POST['columns'][$columnIndex]['data'];
        $columnSortOrder    = getRequestVar('order');                   // $_POST['order'][0]['dir'];
        /* end table list */

        if ($this->action == 'table') {

            /** получение всех менеджеров */
            $users = $this->getAll($mailing->mailingId, $search['value'], $start, $length, $columnSortOrder, $columnName);

            /** получение кол-во менеджеров */
            $total = $this->total($mailing->mailingId, $search['value']);

            /** получение кол-во менеджеров при фильтрации */
            $totalFiltered = $this->countTableFiltered($mailing->mailingId, $search['value']);

            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => intval($total),
                "recordsFiltered"   => intval($totalFiltered),
                "data"              => $users
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        } else {

            $mailing->edit();
            if (!empty($mailing->mailingId) && empty($mailing->mailing)) $this->errors['template_empty'] = true;
            if (!empty($mailing->mailing)) {
                if (!($mailing->mailing instanceof \stdClass)) $mailing->mailing = (object)$mailing->mailing;

                $mailing->mailing->statusName = $this->statuses[$mailing->mailing->status];
//            $mailing->mailing->addedOn = langDate(adjustTime($mailing->mailing->addedOn, false, 'd.m.Y'));
            }

            /** кол-во пользователей */
            $this->smarty->assign('total', $this->getTotal());
            $this->smarty->assign('totalSend', $this->totalSend($mailing->mailingId));
            $this->smarty->assign('totalDelivered', $this->totalDelivered($mailing->mailingId));
            $this->smarty->assign('totalError', $this->totalError($mailing->mailingId));
            $this->smarty->assign('mailing', $mailing->mailing);

            if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        }

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('botmymailings', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.mailingstats.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }





    /**
     * получить пользователей
     *
     * @param int $limit
     * @param int $startFrom
     * @return array|false|mixed|string|null
     */
    private function getUsers(int $limit, int $startFrom = 0)
    {
        $users = DB::init()->connect()->table('telegram_user')->join('telegram_user_chat', 'user_id', '=', 'id')
            ->select('id, chat_id, user_id, mailing')
            ->orderBy('id', 'DESC')
            ->limit($limit)->offset($startFrom)->getAll();

        return $users;
    }

    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function getTotal()
    {
        return DB::init()->connect()->table('telegram_user')->count('*', 'count')->getValue();
    }

    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function totalSend($mailingId)
    {
        return DB::init()->connect()->table('telegram_mailing_stats')->where('mailing_id', $mailingId)->count('*', 'count')->getValue();
    }
    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function totalError($mailingId)
    {
        return DB::init()->connect()->table('telegram_mailing_stats')->where('mailing_id', $mailingId)->where('state', 'ERROR')->count('*', 'count')->getValue();
    }/**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function totalDelivered($mailingId)
    {
        return DB::init()->connect()->table('telegram_mailing_stats')->where('mailing_id', $mailingId)->where('state', 'OK')->count('*', 'count')->getValue();
    }

    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function getAll($mailingId, ?string $query, int $page, int $limit, $columnSortOrder = null, $columnName = null)
    {
        $columnIndex = $columnSortOrder[0]['column'];

//        if ($columnSortOrder) {
//            $orderBy = 'tms.'.$columnName[$columnIndex]['data'] . " " . strtoupper($columnSortOrder[0]['dir']);
//        } else {
            $orderBy = 'tms.id DESC';
//        }
        if (!empty($query)) {
            DB::init()->connect()->like('CONCAT_WS(email, loginName, fullName, firstName, lastName, phone)', "%$query%");
        }

        $users = DB::init()->connect()->table('telegram_mailing_stats AS tms')
            ->join('telegram_user AS tu', 'tu.id', '=', 'tms.user_id')
            ->select('*')
            ->where('tms.mailing_id', $mailingId)->limit($page, $limit)->orderBy($orderBy)->getAll();
//        print_r(DB::init()->connect()->getQuery());

        return $users;
    }


    /**
     * @param string|null $query
     * @return mixed|string|null
     */
    private function total($mailingId, ?string $query)
    {
        if (!empty($query)) {
            DB::init()->connect()->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('firstName', "%$query%")->orLike('lastName', "%$query%")->orLike('address', "%$query%")->orLike('phone', "%$query%");
        }

        $users = DB::init()->connect()->table('telegram_mailing_stats')->count('*', 'count')->where('mailing_id', $mailingId)->getValue();

        return  $users;
    }

    /**
     * @param string|null $query
     * @return mixed|string|null
     */
    private function countTableFiltered($mailingId, ?string $query)
    {
        if (!empty($query)) {
            DB::init()->connect()->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('fullName', "%$query%")->orLike('firstName', "%$query%")->orLike('lastName', "%$query%")->orLike('phone', "%$query%");
        }

        $users = DB::init()->connect()->table('telegram_mailing_stats')->count('*', 'count')->where('mailing_id', $mailingId)->getValue();

        return  $users;
    }


}