<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class StatsVisitorsAdmin
 */
class StatsVisitorsAdmin extends AdminMnv
{

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $stats = new Stats();

        $dateSelector = new StatsDateSelector();
        $typeSelector = new StatsTypeSelector();

        $this->smarty->assign('activeItem', 'visitors');
        $this->smarty->assign('title', lang('stats:visitorsTitle'));

        $domain = getRequestVar('domain','');
        $this->page   = (int) getRequestVar('page',1);

        $visitors = $stats->getStatsVisitors($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $domain, $this->page);
        if (!empty($visitors)) foreach ($visitors as $visitor) {
            $visitor->firstVisitOn = langDate(adjustTime($visitor->firstVisitOn, false, 'd.m.Y H:i'));
            if (!empty($visitor->referer)) {
                $result = parseReferer($visitor->referer);
                $visitor->refererUrl = $result['refererUrl'];
                if (isset($result['refererWebsite'])) $visitor->refererWebsite = $result['refererWebsite'];
            }
            $visitors[$visitor->visitorId] = $visitor;
        }
        /** page numbering */
        $totalItems = $stats->getTotalStatsVisitors($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $domain);
        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 4, 4, 2);

        $this->smarty->assign('visitors', $visitors);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);
        $this->smarty->assign('page', $this->page);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('visitors', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('stats.visitors.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

}

