<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class StatsVisitorAdmin
 */
class StatsVisitorAdmin extends AdminMnv
{
    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $stats = new Stats();

        $dsCookieName = 'visitorDateSelector';
        $dateSelector = new StatsDateSelector();
        $typeSelector = new StatsTypeSelector();
        $sortVisits = false;

        $this->smarty->assign('activeItem','visitor');
        $this->smarty->assign('title', lang('stats:visitor'));

        $visitorId = getRequestVar('visitorId', '');
        $this->page = (int) getRequestVar('page', 1);

        /** получить информацию о посетителе */
        $visitor = $stats->getStatsVisitor($visitorId);
        if (empty($visitorId) || empty($visitor)) die('Visitor Not Found');
        $visitor->firstVisitOn = langDate(adjustTime($visitor->firstVisitOn, false, 'l, M d, Y - H:i'));

        if ($visitor->isBot) {
            header("HTTP/1.0 301 Moved Permanently");
            header("Location: index.php?mod=bot&visitorId=$visitorId".(!empty($typeSelector->filterTypeId) ? "&filterTypeId=$typeSelector->filterTypeId" : ''));
            exit;
        }

        $visits =  $stats->getStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId, $this->page);
        if (!empty($visits)) {
            foreach ($visits as $visitId => $visit) {
                $visits[$visitId]->typeName  = lang('visitTypes:'.$visit->typeId);
                $visits[$visitId]->visitDate = langDate(adjustTime($visit->visitDate, false, 'd.m.Y H:i:s'));
                $visitTypes[$visit->typeId]  = $visit->typeId;
            }

            /** section visits */
            if(!empty($visitTypes[2]))
                $visits = $stats->sectionVisits($visits);
            /** article visits */
            if (!empty($visitTypes[3]))
                $visits = $stats->articleVisits($visits);
            /** search visits */
            if (!empty($visitTypes[4]))
                $visits = $stats->searchVisits($visits);
            /** error visits */
            if (!empty($visitTypes[6]))
                $visits = $stats->errorVisits($visits);
            /** RSS visits */
            if (!empty($visitTypes[7]))
                $visits = $stats->rssVisits($visits);
        }

        /** page numbering */
        $totalItems = $stats->getTotalStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId);
        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 1, 1, 2);
        $this->smarty->assign('pageNums', $pages);

        /** получить больше информации о посетителе */
        if (!empty($visitor->visitId)) $visitor->firstVisit = $stats->getVisitInfo($visits, $visitor->visitId);

        /** отличия от статистикой бота */
        if (!empty($visitor->referer)) {
            $parseReferer = parseReferer($visitor->referer);
            $visitor->refererUrl = $parseReferer['refererUrl'];
            $visitor->refererWebsite = $parseReferer['refererWebsite'] ?? '';
        }

        $this->smarty->assign('visitor', $visitor);

        /** сортировка посещений, потому что добавлены скрытые посещения */
        if ($sortVisits == true) usort($visits, array($stats, 'sortByVisitDate'));

        $this->smarty->assign('visits', $visits);
        $this->smarty->assign('page', $this->page);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('visitors', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('stats.visitor.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }








}