<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;


/**
 * Class StatsErrorAdmin
 */
class StatsErrorAdmin extends AdminMnv
{
    protected $requestUri;
    protected $manager;

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $stats = new Stats();

        $this->smarty->assign('activeItem','errors');
        $this->smarty->assign('title', lang('stats:errorInfo'));

        $this->requestUri = getRequestVar('requestUri');
        $this->page = (int)getRequestVar('page', 1);

        $dateSelector = new StatsDateSelector();

        $visits = $stats->getStatsError($dateSelector->dateStart, $dateSelector->dateEnd, $this->requestUri, $this->page);
        if (!empty($visits)) foreach($visits as $visitId => $visit) $visits[$visitId]->visitDate = langDate(adjustTime($visit->visitDate, false, 'd M, H:i:s'));

        /** page numbering */
        $totalItems = $stats->getTotalStatsError($dateSelector->dateStart, $dateSelector->dateEnd, $this->requestUri);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 4, 4, 2);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);

        $this->smarty->assign('visits', $visits);
        $this->smarty->assign('page', $this->page);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('errors', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('stats.error.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }
}
