<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;

/**
 * Class StatsDateSelector
 */
class StatsDateSelector extends AdminMnv
{

    public $simplePeriod;
    public $simplePeriods;
    public $dateStart;
    public $dateEnd;

    /**
     * StatsDateSelector constructor.
     */
    public function __construct()
    {
        parent::__construct();

        if (empty($dsCookieName)) $dsCookieName = 'mainDateSelector';

        $dsCookie        = getRequestVar($dsCookieName, '',  true,  true);
        $newSimplePeriod = getRequestVar('newSimplePeriod','');
        $newDateStart    = getRequestVar('newDateStart');
        $newDateEnd      = getRequestVar('newDateEnd');


        if (!empty($dsCookie)) $dsCookie = @unserialize($dsCookie);
        if (!empty($newDateStart)) $this->dateStart = "$newDateStart[Year]-$newDateStart[Month]-$newDateStart[Day]";
        if (!empty($newDateEnd)) $this->dateEnd = "$newDateEnd[Year]-$newDateEnd[Month]-$newDateEnd[Day]";

        if (!empty($newSimplePeriod)) $this->simplePeriod = $newSimplePeriod;

        if (!empty($newDateStart) && !empty($newDateEnd)) {
            /* date range has been selected */
            $this->smarty->assign('page', $this->page);
            unset($dsCookie['simplePeriod']);
            $dsCookie['dateStart'] = $this->dateStart;
            $dsCookie['dateEnd']   = $this->dateEnd;
            setcookie($dsCookieName, serialize($dsCookie), time() + 60*60*24*180);

        } elseif(!empty($newSimplePeriod)) {
            /* predefined period has been selected */

            $this->smarty->assign('page', $this->page);
            unset($dsCookie['dateStart']);
            unset($dsCookie['dateEnd']);
            $dsCookie['simplePeriod'] = $this->simplePeriod;
            setcookie($dsCookieName, serialize($dsCookie), time() + 60*60*24*180);

        } elseif (!empty($dsCookie['dateStart']) && !empty($dsCookie['dateEnd'])) {
            /* predefined date range from cookie */
            $this->dateStart = $dsCookie['dateStart'];
            $this->dateEnd   = $dsCookie['dateEnd'];
        } elseif (!empty($dsCookie['simplePeriod'])) {
            /* predefined period from cookie */
            $this->simplePeriod = $dsCookie['simplePeriod'];
        } else {
            /* default period is "today" */
            $this->simplePeriod = 'today';
        }

        $this->simplePeriod($this->simplePeriod);

        $this->smarty->assign('dateStart', $this->dateStart);
        $this->smarty->assign('dateEnd', $this->dateEnd);

        if(empty($noTimeAdjust)){
            $this->dateStart = adjustTime($this->dateStart.' 00:00:00', true);
            $this->dateEnd   = adjustTime($this->dateEnd.' 23:59:59', true);
        }
        $this->smarty->assign('simplePeriods', $this->simplePeriods);
    }

    /**
     * Установка времени за определенный период
     * @param $simplePeriod
     */
    public function simplePeriod($simplePeriod)
    {
        if(!empty($simplePeriod)){
            switch ($simplePeriod){
                case 'yesterday':
                    $this->dateEnd = $this->dateStart = gmdate('Y-m-d', strtotime("-1 day " . $this->config['hour_adjustment']." hours ".$this->config['minute_adjustment']." minutes"));
                    break;
                case 'last7days':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    $this->dateStart = gmdate('Y-m-d', strtotime("-1 week " . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    break;
                case 'thismonth':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    $this->dateStart = gmdate('Y-m-01', strtotime("" . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    break;
                case 'lastmonth':
                    $this->dateEnd = gmdate('Y-m-d', mktime($this->config['hour_adjustment'], $this->config['minute_adjustment'], 0, date('n'), 0));
                    $this->dateStart = gmdate('Y-m-01', strtotime("-1 month " . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    break;
                case 'alltime':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    $this->dateStart = '2017-01-01';
                    break;
                case 'today':
                default:
                    $this->dateEnd = $this->dateStart = gmdate('Y-m-d', strtotime("" . $this->config['hour_adjustment'] . " hours " . $this->config['minute_adjustment'] . " minutes"));
                    break;
            }
            $this->simplePeriods = array(
                'today'     => lang('stats:periods:today'),
                'yesterday' => lang('stats:periods:yesterday'),
                'last7days' => lang('stats:periods:last7days'),
                'thismonth' => lang('stats:periods:thisMonth'),
                'lastmonth' => lang('stats:periods:lastMonth'),
                'alltime'   => lang('stats:periods:allTime'),
            );
            $this->smarty->assign('simplePeriod', $simplePeriod);
        } else {
            $this->simplePeriods = array(
                ''=>'',
                'today'     => lang('stats:periods:today'),
                'yesterday' => lang('stats:periods:yesterday'),
                'last7days' => lang('stats:periods:last7days'),
                'thismonth' => lang('stats:periods:thisMonth'),
                'lastmonth' => lang('stats:periods:lastMonth'),
                'alltime'   => lang('stats:periods:allTime'),
            );
            $this->smarty->assign('simplePeriod', '');
        }
    }
}
