<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Socials\Socials;

/**
 * Class SocialsAdmin
 */
class SocialAdmin extends AdminMnv
{
    public function fetch()
    {
        $socials =  new Socials();

        $this->smarty->assign('activeItem','socials');
        $this->smarty->assign('title', lang('settings:social'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        $socials->social   = (object) getRequestVar('social','', true);
        $socials->socialId = (int) getRequestVar('id','');

        if ($this->action == 'add' || $this->action == 'edit') {

            $socials->edit();

        } else if ($this->action == 'save') {

            if (empty($socials->social->name)) $this->errors['errorName'] = true;
            if (empty($socials->social->fileName)) $this->errors['fileNameEmpty'] = true;

            if (!$socials->isFileName($socials->social->fileName)) $this->errors['fileNameError'] = true;

            if (empty($this->errors)) {
                if (empty($socials->socialId)) {
                    $socials->add($socials->social);
                } else {
                    $socials->update($socials->social);
                }
                $this->messages['saved'] = true;
            }

            $socials->edit();


            if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=socials");
        }


        if (!($socials->social instanceof stdClass)) $socials->social = (object)$socials->social;


        $this->smarty->assign('social', $socials->social);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('socials', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('social.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }


}



