<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');



use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Brands;
use Mnv\Models\Features;
use Mnv\Models\Variants;
use Mnv\Models\Products;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;

/**
 * Class ArticlesAdmin
 */
class ProductAdmin extends AdminMnv
{

    protected $image;
    protected $images;
    protected $gallery;
    protected $imageId;
    protected $imageIds;
    protected $imageAlt;
    protected $imageLink;
    protected $val;

    protected $variants;
    protected $options;

    public $sectionId;
    public $featureId;

    /**
     * Вывод всех статей
     *
     * @return string
     * @throws NoContentException
     * @throws \SmartyException
     */
    public function fetch()
    {
        global $SECTIONS;

        $products       = new Products();
        $variantProduct = new Variants();
        $feature        = new Features();
        $brands         = new Brands();

        $features = array();


        $this->smarty->assign('activeItem', $this->module.'s');
        $this->smarty->assign('title', lang($this->module.'s:title'));
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** бренды для продута */
//        $brands = $brands->getBrands();
        $this->smarty->assign('brands',  $brands->getBrands());
        $typeContent = getRequestVar('typeContent', $this->module.'s');

        /** получение ID для удаления / изменение статуса / удаление и обновление основной картинки */
        $products->articleId    = (int) getRequestVar('id', '');
        $this->sectionId        = (int) getRequestVar('sectionId', '');
        $this->featureId        = (int) getRequestVar('featureId', '');

        /** получение параметров `product` */
        $products->content       = (object)getRequestVar('product', '', true);

        /** свойства товара */
        $this->options          = getRequestVar('options', '', true);
        $newFeaturesNames       = getRequestVar('new_features_names', '', true);
        $newFeaturesValues      = getRequestVar('new_features_values', '', true);

        /** дата публикации товара */
        $date               = getRequestVar('date', '', true);
        /** варианты товара */
        $this->variants     = getRequestVar('variants', '', true);

        /** фильтрация */
        $query         = getRequestVar('query', '');
        $section       = (int) getRequestVar('section', '', '', $checkCookie = true);
        $status        = getRequestVar('status', '');

        /** работа с галереей */
        $this->image        = getRequestVar('image', '', true);
        $this->gallery      = getRequestVar('gallery', '', true);
        $this->imageIds     = getRequestVar('imageIds', '', true);
        $this->imageId      = (int) getRequestVar('imageId', '');
        $this->imageAlt     = getRequestVar('imageAlt', '');
        $this->imageLink    = getRequestVar('imageLink', '');

        $sections = Helpers::init()->getSectionContent('', $typeContent);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        // action добавление/редактирование
        if ($this->action == 'add' || $this->action == 'edit') {
            try {
                $products->edit();
            } catch (NoContentException $e) { /** контент не найден */
                echo "notFound();";
                exit;
            }
        }
        // action сохранение
        else if ($this->action == 'save' || $this->action == 'apply') {

            // TODO: попробовать преобразовать `$products->content` в объект
//             print_r($products->content);
            /** проверка полей */
            if (empty($products->content->title)) $this->errors['title'] = true;

            /** тип контента */
            if (empty($products->content->typeContent)) $products->content->typeContent = $typeContent;

            /** установка даты */
            $products->content->publishedOn = Helpers::init()->dateFormation($date);

            /** проверка доступных разделов */
            if (empty($products->content->sectionId) || empty($sections[$products->content->sectionId])) $this->errors['sectionId'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $products->checkFileName($products->content->fileName)) {
                if ($fileName == $products->content->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $products->content->fileName = $fileName;
                }
            }

            /** варианты товара `variants` */
            $variants = $variantProduct->convertVariants($this->variants);

            /** свойства товара `options` */
            $options = $feature->convertOption($this->options);

            /** основная картинка */
            $this->images['fileId'] = !empty($this->image) ? $this->image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $products->content->enableGallery = isset($products->content->enableGallery) ? 1 : 0;
            $this->images['gallery'] = !empty($this->gallery) ? $this->gallery : null;

            $sectionFeatures = array();
//print_r($products->content);
            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $products->content->url = $SECTIONS[$products->content->sectionId]->path.'/'.$products->content->fileName.'.'.$this->config['file_extension'];

                /** если пустой ID то создаем новый продукт / если существует ID то редактируем продукт */
                if (empty($products->articleId)) {

                    try {
                        $products->add((array)$products->content, $this->images, $this->managers->manager);

                        if (is_array($variants)) {
                            $variantsIds = array();
                            foreach ($variants as &$variant) {
                                if ($variant->stock == '∞' || $variant->stock == '') $variant->stock = null;

                                /** добавление варианта */
                                $variant->productId = $products->articleId;
                                $variant->id = $variantProduct->addVariant($variant);

                                /** возвращает вариант товара */
                                $variant = $variantProduct->getVariant($variant->id);
                                if (!empty($variant->id)) $variantsIds[] = $variant->id;
                            }

                            /** Отсортировать  варианты */
                            asort($variantsIds);
                            $i = 0;
                            foreach ($variantsIds as $variantId) {
                                /** обновляет вариант товара  */
                                $variantProduct->updateVariant($variantsIds[$i], ['orderBy' => $variantId]);
                                $i++;
                            }
                        }

                        /** Характеристики продукта */

                        /** получение свойств для продукта */
                        foreach ($feature->getAllProductFeatures($products->content->sectionId) as $f) $sectionFeatures[] = $f->id;
                        if (is_array($options)) {
                            foreach ($options as $option) {
                                if (in_array($option->featureId, $sectionFeatures))
                                    $feature->updateOption($products->articleId, $option->featureId, $option->value);
                            }
                        }

                        /** Новые характеристики продукта */
                        if (is_array($newFeaturesNames) && is_array($newFeaturesValues)) {
                            foreach($newFeaturesNames as $i => $name) {
                                $value = trim($newFeaturesValues[$i]);
                                if (!empty($name) && !empty($value)) {
                                    $feature->featureId = $feature->existsFeature(trim($name));
                                    if (empty($feature->featureId)) {
                                        $feature->insert(['sectionIds' => json_encode([$products->content->sectionId]), 'name'=> trim($name)]);
                                    }

                                    $feature->updateOption($products->articleId, $feature->featureId, $value);
                                }
                            }
                            /** возвращаем характеристики продукта */
                            $options = $feature->getProductOptions($products->articleId);
                            $this->smarty->assign('options', $options);
                        }

                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен контент «" . $products->content->title . "»", $this->managers->manager);

                        if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=".$this->module."&action=edit&id={$products->articleId}&page={$this->page}");

                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {

                    try {
                        /** обновляем сам продукт */
                        $products->update((array)$products->content, $this->images, $this->managers->manager);

                        if (is_array($variants)) {
                            $variantsIds = array();

                            foreach($variants as &$variant) {
                                if ($variant->stock == '∞' || $variant->stock == '') $variant->stock = null;

                                /** если уже существует вариант продукта то обновляем его в противном случае добавляем */
                                if (isset($variant->id) && !empty($variant->id)) {
                                    /** обновляем вариант продукта  */
                                    $variant->id = $variantProduct->updateVariant($variant->id, $variant);

                                } else {
                                    /** добавление варианта */
                                    $variant->productId = $products->articleId;
                                    $variant->id = $variantProduct->addVariant($variant);
                                }

                                /** возвращаем вариант продукта  */
                                $variant = $variantProduct->getVariant($variant->id); // ОШИБКА
                                if (!empty($variant->id))
                                    $variantsIds[] = $variant->id;
                            }

                            /** возвращает варианты товара */
                            $currentVariants = $variantProduct->getVariants(['productId' => $products->articleId]);

                            /** Удаляем непереданные варианты */
                            foreach($currentVariants as $currentVariant)
                                if (!in_array($currentVariant->id, $variantsIds))
                                    $variantProduct->deleteVariant($currentVariant->id);

                            /** Отсортировать  варианты */
                            asort($variantsIds);
                            $i = 0;
                            foreach($variantsIds as $variant_id) {
                                /** обновляем вариант продукта */
                                $variantProduct->updateVariant($variantsIds[$i], ['orderBy' => $variant_id]);
                                $i++;
                            }
                        }

                        /** Характеристики продукта */

                        /** Удалим все характеристики из продукта */
                        $productOptions = $feature->getProductOptions($products->articleId);
                        if (!empty($productOptions)) {
                            foreach ($productOptions as $productOption)
                                $feature->deleteOption($products->articleId, $productOption->featureId);
                        }
                        /** получение свойств для продукта */
                        foreach ($feature->getAllProductFeatures($products->content->sectionId) as $f) $sectionFeatures[] = $f->id;
                        if (is_array($options)) {
                            foreach ($options as $option) {
                                if (in_array($option->featureId, $sectionFeatures))
                                    $feature->updateOption($products->articleId, $option->featureId, $option->value);
                            }
                        }

                        /** Новые характеристики */
                        if (is_array($newFeaturesNames) && is_array($newFeaturesValues)) {
                            foreach($newFeaturesNames as $i => $name) {
                                $value = trim($newFeaturesValues[$i]);
                                if (!empty($name) && !empty($value)) {
                                    $feature->featureId = $feature->existsFeature(trim($name));
                                    if (empty($feature->featureId)) {
                                        $feature->add(['sectionIds' => json_encode([$products->content->sectionId]), 'name' => trim($name)]);
                                    }
                                    $feature->updateOption($products->articleId, $feature->featureId, $value);
                                }
                            }
                            /** возвращаем характеристики продукта */
                            $options = $feature->getProductOptions($products->articleId);
                            $this->smarty->assign('options', $options);
                        }

                        $this->messages['saved'] = true;
                        $this->logger->info("Контент «" . $products->content->title . "» отредактирован", $this->managers->manager);

                    } catch (NotUpdateContentException $e) {
                        $products->edit();
                        $this->errors['not_saved'] = true;
                    }
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $products->edit();
            }

            if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=".$this->module."s&page={$this->page}");

        } else if ($this->action == 'deleteImage') {
            if ($products->deleteImage($products->articleId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        } else if ($this->action == 'editPictureInfo') {

            if ($image = $products->editPictureInfo($this->imageId, $this->imageAlt, $this->imageLink)) {
                $result = array('data' => true, 'alt'=>$image['alt'], 'link'=>$image['link']);
            } else {
                $result = array('data' => false);
            }
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        } else if ($this->action == 'sortPictures') {

            $products->sortPictures($this->imageIds);

        } else if ($this->action == 'deletePicture') {
            $result = $products->deletePicture($this->imageId)
                ? array('status' => 200, 'message' => lang('deletingImage'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingImageError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }
        // получить свойства товара от выбранного раздела
        else if ($this->action == 'features') {
            $features = $feature->getAllProductFeatures($this->sectionId);
            if (!empty($products->articleId)) $featureOptions = $feature->getProductOptions($products->articleId);
            foreach($features as &$ft) {
                $ft->value = isset($featureOptions[$ft->id]) ? $featureOptions[$ft->id]->value : '';
            }

            response()->json($features, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }

        // получить свойства товара от выбранного раздела
//        else if ($this->action == 'featureId') {
//
//            $featureValue = $feature->getProductFeatureValue($this->featureId);
//            response()->json($featureValue, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//        }

        if (!($products->content instanceof \stdClass)) $products->content = (object)$products->content;


        /** вывод свойств продукта `variants` (название свойств) */
        if (isset($products->content->sectionId))
            $features = $feature->getAllProductFeatures($products->content->sectionId);
        $this->smarty->assign('features', $features);

        /** вывод характеристик продукта `options` (название характеристик, значение характеристик ) */
//        $options = $feature->getProductOptions($products->articleId);
//        print_r($options);
        $this->smarty->assign('options', $feature->getProductOptions($products->articleId));

        /** вывод варианты товара `product_variants` (название, артикул, цена, старая цена, кол-во) */
        $this->smarty->assign('product_variants', $variantProduct->getVariants(['productId' => $products->articleId]));


//        print_r($features);
//        print_r($product->content);

        $this->smarty->assign('product', $products->content);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

//        var_dump($admin->access);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('products', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('product.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }



}