<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Models\Content;
use Mnv\Core\Managers\Role;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;

/**
 * Class PartnerAdmin
 */
class PartnerAdmin extends AdminMnv
{

    /**
     * Вывод всего контента
     */
    public function fetch()
    {
        global $SECTIONS;

        $content = new Content();

        $module = getRequestVar('mod','');

        $this->smarty->assign('activeItem', $module .'s');
        $this->smarty->assign('title', lang($module .'s:title'));
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** действие */
        $typeContent         = getRequestVar('typeContent', $module .'s');
        $date                = getRequestVar('date', '', true);

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $content->articleId     = (int) getRequestVar('id', '');
        $content->content    = (object)getRequestVar('article', '', true);

        /** фильтрация статей */
        $query         = getRequestVar('query', '');
        $section       = (int) getRequestVar('section', '', '', $checkCookie = true);
        $status        = getRequestVar('status', '');

        /** работа с галереей */
        $image    = getRequestVar('image', '', true);
        $gallery  = getRequestVar('gallery', '', true);
        $imageIds = getRequestVar('imageIds', '', true);
        $imageId  = (int) getRequestVar('imageId', '');
        $picture        = getRequestVar('picture', '', true);

        $sections = Helpers::init()->getSectionContent('', $typeContent);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        if ($this->action == 'add' || $this->action == 'edit') {

            try {
                $content->edit();
            } catch (NoContentException $e) { /** контент не найден */
                $this->errors['article_not_found'] = true;
            }
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($content->content->title)) $this->errors['title'] = true;

            /** тип контента */
            if (empty($content->content->typeContent)) $content->content->typeContent = $typeContent;

            /** установка даты */
            $content->content->publishedOn = Helpers::init()->dateFormation($date);

            /** проверка доступных разделов для статей */
            if (empty($content->content->sectionId) || empty($sections[$content->content->sectionId])) $this->errors['sectionId'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $content->checkFileName($content->content->fileName)) {
                if ($fileName == $content->content->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->content->fileName = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $content->content->enableGallery = isset($content->content->enableGallery) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $content->content->url = $SECTIONS[$content->content->sectionId]->path.'/'.$content->content->fileName.'.'.$this->config['file_extension'];

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($content->articleId)) {

                    try {
                        $content->add($content->content, $images, $this->managers->manager);
                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен контент «" . $content->content->title . "»", $this->managers->manager);

                        if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=". $module ."&action=edit&id={$content->articleId}&page={$this->page}");

                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {
                    try {
                        $content->update($content->content, $images, $this->managers->manager);

                        $this->messages['saved'] = true;
                        $this->logger->info("Контент «" . $content->content->title . "» отредактирован", $this->managers->manager);
                    } catch (NotUpdateContentException $e) {
                        $content->edit();
                        $this->errors['not_saved'] = true;
                    }
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $content->edit();
            }

            if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=". $module ."s&page={$this->page}");

        } else if ($this->action == 'deleteImage') {

            if ($content->deleteImage($content->articleId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        } else if ($this->action == 'editPictureInfo') {

            if ($result = $content->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        } else if ($this->action == 'sortPictures') {

            $content->sortPictures($imageIds);

        } else if ($this->action == 'deletePicture') {
            $result = $content->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('deletingImage'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingImageError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }

        if (!($content->content instanceof \stdClass)) $content->content = (object)$content->content;

        $this->smarty->assign('article', $content->content);
        $this->smarty->assign('typeNews', array('' => 'Выберите тип', 'news' => 'Новости', 'show' => 'Выставка'));

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('partners', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('partner.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

}