<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\Config;
use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Models\Content;
use Mnv\Core\Managers\Role;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\EmptyArticleIdException;
use Mnv\Models\Contents\Exceptions\ContentNotDeletedException;
use Mnv\Models\Contents\Exceptions\NotContentApproveException;

/**
 * Class NewsAdmin
 */
class NewsAdmin extends AdminMnv
{

    /**
     * Вывод всех статей
     */
    public function fetch()
    {
        global $SECTIONS;

        $sectionIds = [];

        $contents = new Content();

        /** title */
        $this->smarty->assign('title', 'Новости и Статьи');
        /** activeItem */
        $this->smarty->assign('activeItem', 'news');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $contents->articleId = (int) getRequestVar('id', '');
        $articleIds    = getRequestVar('articleIds', '', true);

        /** фильтрация статей */
        $section       = (int) getRequestVar('section', '');
        $query         = getRequestVar('query', '');
        $status        = getRequestVar('status', '');

        $typeNews = array('' => 'Выберите тип', 'news' => 'Новости', 'service' => 'Сервисные акции', 'promotions' => 'Акции и спецпредложения', 'smi' => 'СМИ');

        /** действия */
        if ($this->action == 'remove') {

            try {
                $contents->remove($this->managers->manager);
                $this->logger->info("Контент «" . $contents->content->title . "» удален.", $this->managers->manager);
                response()->make("deleteSuccess('" . $contents->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (ContentNotDeletedException $e) { /** ошибка при удаление контента */
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else if ($this->action == 'approve') {

            try {
                $contents->approve($this->managers->manager);
                echo "approveSuccess('" . $contents->articleId . "');";
                exit;
            } catch (NotContentApproveException $e) { /** ошибка при одобрение контента */
                response()->make("approveError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else if ($this->action == 'reorder') {

            $ids = array_values($articleIds);
            sort($articleIds);
            $articleIds = array_reverse($articleIds);
            $contents->reorder($ids, $articleIds);

        } else if ($this->action == 'status') {

            try {
                $contents->status();
                response()->json($contents->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else {

            if (!empty($section) && !empty($SECTIONS[$section])) {
                $sectionIds = array($section);
                if (!empty($SECTIONS[$section]->allChildren)) {
                    $sectionIds = array_merge($sectionIds, $SECTIONS[$section]->allChildren);
                }
            }

            /** получение разделов по типу контента */
            $sections = Helpers::init()->getSectionContent(null, 'news', 3);

            /** получение всех статей */
            $contents->listContent($query, $status, 'news', $sectionIds, 'articleId DESC', $this->managers->manager);
            if (!is_null($contents->contents)) {
                foreach ($contents->contents as $articleId => $content) {
                    $contents->contents[$articleId]->statusName     = lang('general:statuses:' . $content->status);
                    $contents->contents[$articleId]->publishedOn    = langDate(adjustTime($content->publishedOn, false, 'd.m.Y'));
                    $contents->contents[$articleId]->image          = $contents->getFile($content->articleId);
                    $contents->contents[$articleId]->section        = array();
                    if (isset($SECTIONS[$content->sectionId])) $contents->contents[$articleId]->section = $SECTIONS[$content->sectionId];
                }
            }

            /** Получение кол-во статей */
            $contents->total($query, $status, 'news', $sectionIds, $this->managers->manager);

            /** pagination */
            $pages = getPageNums($contents->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $contents->total);
            $this->smarty->assign('articles', $contents->contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);
        }


        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('news', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('news.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }


}