<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Users\UserFactory;
use Mnv\Models\Exceptions\InvalidEmailException;
use Mnv\Models\Users\Exceptions\NotUpdateUserException;

/**
 * Class ManagersAdmin
 */
class ManagerAdmin extends AdminMnv
{

    /**
     * Вывод всех пользователей
     */
    public function fetch()
    {
        $adminUser = UserFactory::adminUser();

        $this->smarty->assign('activeItem', 'managers');
        $this->smarty->assign('title', lang('managers:title'));

        $this->smarty->assign('statuses', lang('managers:statuses'));
        $this->smarty->assign('verified', lang('managers:verified'));

        $accessRole = lang('managers:accessRole');
        if ($this->managers->manager->accessLevel == 1) {
            $accessRole = array_diff_key($accessRole, array_flip([Role::CONSUMER, Role::SUBSCRIBER]));
        } else {
            $accessRole = array_diff_key($accessRole, array_flip([Role::DEVELOPER, Role::MANAGER, Role::CONSUMER, Role::SUBSCRIBER]));
        }
        $this->smarty->assign('accessRole', $accessRole);

        $adminUser->user    = (object) getRequestVar('manager','');
        $adminUser->userId  = (int) getRequestVar('id','');
        $accessLevelId      = (int) getRequestVar('accessLevelId','');
        $image              = getRequestVar('image', '', true);


        if ($this->action == 'add' || $this->action == 'edit') {

            $adminUser->edit();

            $permission = $adminUser->accessRights($adminUser->user->accessLevel ?? 0);
            $this->smarty->assign('permission', $permission);

        }

        /** сохрание жанных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** loginName */
            if (!empty($adminUser->user->loginName)) {
                $adminUser->user->loginName = str_replace(" ", '', $adminUser->user->loginName);
                if (empty($adminUser->user->loginName) || preg_match('/[^a-zA-Z0-9]/', $adminUser->user->loginName)) $this->errors['loginName'] = true;
            } else {
                $this->errors['login_empty'] = true;
            }

            /** проверяем существование loginName */
            if ($fileName = $adminUser->checkExistenceLoginName($adminUser->user->loginName)) {
                if ($fileName == $adminUser->user->loginName) {
                    $this->errors['login_exists'] = true;
                } else {
                    $adminUser->user->loginName = $fileName;
                }
            }

            /** fullName */
            $adminUser->user->fullName  = trim($adminUser->user->fullName);
            if (empty($adminUser->user->fullName) || preg_match('/[^[а-яА-ЯёЁa-zA-Z0-9]+$]/', $adminUser->user->fullName)) $this->errors['fullName'] = true;

            /** email */
            if (!empty($adminUser->user->email)) {
                try {
                    self::validateEmailAddress($adminUser->user->email);
                } catch (InvalidEmailException $error) {
                    $this->errors['invalid_email'] = true;
                }
            }

            /** password */
            if (empty($adminUser->userId) && empty($adminUser->user->password)) $this->errors['password'] = true;

            /** permissions */
            if (!empty($adminUser->user->permissions)) {
                $adminUser->user->permissions = implode(",", $adminUser->user->permissions);
            } else {
                $this->errors['permission'] = true;
            }

            /** fileId */
            $adminUser->user->fileId = !empty($image['fileId'])  ? $image['fileId'] : null;

            if (empty($this->errors)) {

                if (empty($adminUser->userId)) {

                    if ($adminUser->add($adminUser->user, $this->managers->manager)) {
                        $this->logger->info("Добавлен новый менеджер", $this->managers->manager);
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=manager&action=edit&id={$adminUser->userId}");

                } else {

                    $adminUser->getOldDataUser($adminUser->userId);
                    if (empty($adminUser->oldUser)) $this->errors['user_not_found'] = true;

                    if (($adminUser->user->accessLevel != Role::ADMIN) && ($adminUser->oldUser->accessLevel == Role::ADMIN)) {
                        if ($adminUser->accessLevelRole($adminUser->user, Role::ADMIN)) $this->errors['no_more_admins'] = true;
                    }
                    if (($adminUser->user->accessLevel != Role::DEVELOPER) && ($adminUser->oldUser->accessLevel == Role::DEVELOPER)) {
                        if (!$adminUser->accessLevelRole($adminUser->user,  Role::DEVELOPER))  $this->errors['no_more_developers'] = true;
                    }

                    if (empty($this->errors)) {
                        try {
                            $adminUser->update($adminUser->user, $this->managers->manager);
                            $this->logger->info("Менеджер " . $adminUser->user->fullName . " отредактирован", $this->managers->manager);
                            $this->messages['saved'] = true;
                        } catch (NotUpdateUserException $e) {
                            $this->errors['not_saved'] = true;
                        }
                    }
                }

                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=managers");
            }

            $adminUser->edit();
            $permission = $adminUser->accessRights($adminUser->user->accessLevel ?? 0);
            $this->smarty->assign('permission', $permission);
        }

        else if ($this->action == 'accessLevel') {

            if (!empty($accessLevelId)) {
                $result = $adminUser->accessRights($accessLevelId);
                $this->smarty->assign('permission', $result);
                $items = $this->smarty->fetch('module/manager-access-level.tpl');

                $this->response = array('status' => 200, 'accessLevelId' => $accessLevelId, 'permission' => $items);
            } else {
                $this->response = array('status' => 500, 'accessLevelId' => $accessLevelId, 'permission' => '', 'error' => 'Пустой ID' );
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        } else if ($this->action == 'upload') {

            // TODO: что то сделать

       } else if ($this->action == 'deleteImage') {
            if ($adminUser->removeUserImage()) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        }

        if (!($adminUser->user instanceof stdClass)) $adminUser->user = (object)$adminUser->user;

        $this->smarty->assign('totalArticle', $adminUser->totalArticle);
        $this->smarty->assign('manager', $adminUser->user);
        $this->smarty->assign('action', $this->action);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('managers', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('manager.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }


}
