<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use League\Flysystem\FilesystemException;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class LogoAdmin
 */
class LogoAdmin extends AdminMnv
{

    private $fileManager;

    public function fetch()
    {

        $this->smarty->assign('activeItem','logo');
        $this->smarty->assign('title', lang('logo:logo'));

        $downloadableFile   = getRequestFiles();
        $logo 	        = getRequestVar('logo','');

        $this->fileManager = new \Mnv\Core\Files\FileManager(SITE_ROOT.'/uploads/');

        if ($this->action == 'upload') {

            $this->upload($downloadableFile);
            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit();

        } else if ($this->action == 'remove') {

            if ($this->fileManager->filesystem->fileExists($logo['logoUrl'])) {
                $this->fileManager->filesystem->delete($logo['logoUrl']);

                response()->make("deleteSuccess('1');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();

            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }

        $logos = new \stdClass();
        if ($file = getLogoFile(SITE_ROOT.'/uploads/')) {
            $logos->logoName = 'logo';
            $logos->logoUrl = $file[0];
            $logos->logoType = preg_replace('/^.*\./', '', $file[0]);
            $logos->size =  $this->fileManager->filesystem->fileSize($file[0]);
        }

        if (!empty($logos)) $this->smarty->assign('logos', $logos);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('logo', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('logo.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }


    /**
     * Загрузка или обновление логотипа
     * @param $file
     */
    public function upload($file)
    {
        $extensions = array('jpeg', 'jpg', 'png', 'gif', 'svg');
        $ext = strtolower(pathinfo($file['file']['name'], PATHINFO_EXTENSION));

        /*; удаление старого логотипа */
        if ($fileOld = getLogoFile(SITE_ROOT.'/uploads/')) {
            $this->fileManager->filesystem->delete($fileOld[0]);
        }

        if ($file['file']['size'] < ($this->config['max_up_size'] * 1024)) {
            if (in_array($ext, $extensions)) {
                $stream = fopen($file['file']['tmp_name'], 'r+');
                try {
                    $this->fileManager->filesystem->writeStream('logo.' . $ext, $stream);
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:1'));
                } catch (FilesystemException $e) {
                    $this->response = array('status' => 500, 'message' => lang('fileManager:errors:0'), 'error' => $e->getMessage());
                }
                if (is_resource($stream)) {
                    fclose($stream);
                }
            } else {
                $this->response = array('status' => 500, 'message' => lang('logo:errors:1'));
            }
        } else {
            $this->response = array('status' => 500, 'message' => lang('fileManager:errors:15'), 'error' => lang('fileManager:errors:15') . ' (MAX UP SIZE)');
        }
    }




}

  

	


