<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\DB;
use Mnv\Models\Log;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class LogActionAdmin
 */
class LogAdmin extends AdminMnv
{

    public $dataLogs;

    public function action()
    {
        switch ($this->action) {
            case 'clear':
                $this->clear();
                break;
        }
    }

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $log = new Log();
        $this->smarty->assign('activeItem','log');
        $this->smarty->assign('title', 'Лог действий');

        $this->action = getRequestVar('action', '');
        $this->page   = (int) getRequestVar('page','1');

        $this->action();


        $this->smarty->assign('page', $this->page);

        $log->getAllLog();
        foreach ($log->logs  as $data) {
            $data->date_log = langDate(adjustTime($data->date_log, false, 'd.m.Y H:i'));
		    $this->dataLogs[] = $data;
        }

        $log->total();
//        var_dump($log->total);
        $pages = getPageNums($log->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalLogs', $log->total);
        $this->smarty->assign('pageNums', $pages);
		$this->smarty->assign("datalog", $this->dataLogs);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('log', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('log.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

    /**
     * очищение действий в админке
     */
    public function clear()
    {
        DB::init()->connect()->table('log')->delete();
    }
}

