<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Models\Languages;
use Mnv\Core\Managers\Role;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class LanguagesAdmin
 */
class LanguagesAdmin extends AdminMnv
{
    private static $_table = 'languages';

    protected $lang;
    protected $language;
    protected $languageId;
    protected $languageIds;

    public $defaultLanguageOptions = array();

    /**
     * @return string
     */
    public function fetch()
    {
        global $LANGUAGES;

        $languages = new Languages();


        $this->smarty->assign('activeItem','languages');
        $this->smarty->assign('title', lang('languages:title'));

        $this->action      = getRequestVar('action','');
        $this->language    = getRequestVar('language', '',  true);
        $this->languageId  = getRequestVar('id','');
        $this->languageIds = getRequestVar('languageIds', '', true);

        $this->smarty->assign('statuses', lang('languages:statuses'));

        if ((int) DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue() == 0) {
            $action = array();
            $action['toMultilangMode'] = true;
            $this->smarty->assign('action', $action);
            return $this->smarty->fetch('language.tpl');
        }

        if ($this->action == 'changeDefaultLanguage') {

            if ($languages->changeDefaultLanguage($this->language)) {
                redirect('index.php?mod=languages');
                die('Moving to index.php?mod=languages');
            } else {
                $this->errors['language_not_found'] = true;
            }
        } else if ($this->action == 'confirmDelete') {
            if ($language = $languages->confirmDelete($this->languageId)) {
                if (!empty($language->isDefault) && count($LANGUAGES) > 1){
                    redirect('index.php?mod=languages');
                    die('Moving to index.php?mod=languages');
                } else {
                    $this->smarty->assign('language', $language);
                }
            } else {
                $this->errors['language_not_found'] = true;
            }
        } else if ($this->action == 'remove') {
            if ($languages->remove($this->languageId)) {
                $this->messages['deleted'] = true;
            } else {
                $this->errors['language_not_found'] = true;
            }
        } else if ($this->action == 'status') {
            if ($result = $languages->status($this->languageId)) {
                jsonResponse($result);
            }
        } else if ($this->action == 'reorder') {
            $ids = array_values($this->languageIds);
            sort($this->languageIds);
            $languages->reorder($ids, $this->languageIds);
        } else if ($this->action == 'moveUp') {
            $languages->moveUp($this->languageId);
        } else if ($this->action == 'moveDown') {
            $languages->moveDown($this->languageId);
        }


        $languageArr = $languages->getAllLanguages();
        foreach ($languageArr as $i => $language) {
            $languageArr[$i]->languageTransName = lang('languageList:'.$language->codename);
            $languageArr[$i]->statusName = lang('languages:statuses:'.$language->status);
            if (!$language->isDefault) $this->defaultLanguageOptions[$language->languageId] = $languageArr[$i]->languageTransName;
        }

        $this->smarty->assign('defaultLanguageOptions', $this->defaultLanguageOptions);
        $this->smarty->assign('languages', $languageArr);

        $this->smarty->assign('languageOptions', LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets', Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions', Charset::$charsetOptions);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('languages', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('languages.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}



