<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Models\Languages;
use Mnv\Core\Managers\Role;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class LanguagesAdmin
 */
class LanguageAdmin extends AdminMnv
{
    private static $_table = 'languages';

    protected $lang;
    protected $language;
    protected $languageId;

    public function fetch()
    {
        global $LANGUAGES;

        $languages = new Languages();

        $this->smarty->assign('activeItem','languages');
        $this->smarty->assign('title', lang('languages:title'));
        $this->smarty->assign('statuses', lang('languages:statuses'));

        $this->action     = getRequestVar('action','');
        $this->language   = getRequestVar('language', '', true);
        $this->languageId = getRequestVar('id','');

        if ((int) DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue() == 0) {
            $action = array();
            $action['toMultilangMode'] = true;
        }

        switch ($this->action) {
            case 'add':
                $languages->edit($this->languageId);
                if (count($LANGUAGES) > 0) $this->smarty->assign('adminLangs', getLanguages());
                break;
            case 'edit':
                $this->language = $languages->edit($this->languageId);
                break;
            case 'save':
                /* checking fields */
                if (empty($this->language['languageName'])) $this->errors['languageName'] = true;
                if (preg_match('/[^a-zA-Z]/', $this->language['languageName'])) $this->errors['languageNameCharacters'] = true;

                if (empty($this->language['languageId'])) {
                    /* check codename only for new languages */
                    $this->language['codename'] = strtolower(trim($this->language['codename']));
                    if (empty($this->language['codename'])) $this->errors['codename'] = true;
                    if ($codeName = $languages->isCodeName($this->languageId, $this->language['codename'])){
                       if ($codeName == $this->language['codename']) {
                           $this->errors['codenameExists'] = true;
                       } else {
                           $this->language['codename'] = $codeName;
                       }
                   }
                   if (preg_match('/[^a-z]/', $this->language['codename'])) $this->errors['codenameCharacters'] = true;
                }

                if (empty($this->errors)) {
                    if (empty($this->language['languageId'])) {
                        if ($this->language['languageId'] =  $languages->add($this->language, $this->managers->manager)) {
                           $this->messages['saved'] = true;
                        } else {
                            $this->errors['not_saved'] = true;
                        }
                    } else {
                        if ($languages->update($this->language, $this->managers->manager)) {
                            $this->messages['saved'] = true;
                        } else {
                            $this->errors['not_saved'] = true;
                        }
                    }
                    if (empty($this->errors)) redirect('index.php?mod=languages');
                } else {
                    /* if there are any errors in fields */
                    $this->smarty->assign('action', 'edit');
                    $this->smarty->assign('language', $this->language);
                }
                break;
        }

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (!($this->language instanceof stdClass)) $this->language = (object)$this->language;


        $this->smarty->assign('language', $this->language);

        $this->smarty->assign('languageOptions',    LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets',   Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions',     Charset::$charsetOptions);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('languages', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('language.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }



    }
}



