<?php

namespace Mnv\Admin\Controllers;

/**
 * Class IndexAdmin
 */
class IndexAdmin
{
    /** @var mixed $module */
    private $backendController;

    /** @var array|string|string[]|null  */
    private $backendControllerName;

    /** IndexAdmin constructor. */
    public function __construct()
    {
        /** @var backendControllerName получаем модуль */
        $this->backendControllerName = getRequestVar('mod','');
        $this->backendControllerName = preg_replace("/[^a-z]+/", "", $this->backendControllerName);

//            var_dump($this->backendControllerName);

        if (!empty($this->backendControllerName)) {

            /** получение модуля */
            $moduleControllerName = $this->searchModule($this->backendControllerName);

//            var_dump($moduleControllerName);

            /** Подключаем файл с необходимым модулем */
            require_once  $moduleControllerName.'.php';
            /** Создаем соответствующий модуль */
            $moduleControllerClass =  '\\Mnv\\Admin\\Controllers\\' . $moduleControllerName;

            if (class_exists($moduleControllerClass)) {
                $this->backendController = new $moduleControllerClass();
            } else {
                //todo: можно создать шаблон с выводом информацией о том что забыли создать класс, файл скопировали он существует с таким названием а самого класса нету
                die("Error creating $moduleControllerName class");
            }
        } else {
            redirect('index.php?mod=auth');
        }

//        print_r($this);
    }


    /**
     * stats,overview,visitors,visitor,referer,bots,order,orders,users,user,subscribe,sections,section,sliders,slider,
     * banners,banner,catalog,brands,brand,articles,article,products,product,news,new,gallerys,gallery,setting,logo,
     * settings,socials,social,maps,languages,language,currencies,currency,robots,error,errors,logaction,lowerrors,
     * syserrors,serverinfo,serverinfo,inivars,managers,manager,templates,filemanager,translations,comments,comment,about,doc
     * Отображение запрашиваемого модуля
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        global $smarty;

        $contents = $this->backendController->fetch();
        if ($this->backendController == 'AuthAdmin' || $this->getPermissionByController(get_class($this->backendController)) == 'auth') {
            $smarty->assign("content", false);
        } else {
            $smarty->assign("content", $contents);
        }

        /** Создаем текущую обертку admin (index.tpl) */
        $wrapper = $smarty->getTemplateVars('wrapper');
        if (is_null($wrapper)) {
            $wrapper = 'index.tpl';
        }

        /** Проверяем нам передали итоговую HTML или имя файла шаблона */
        if (!empty($wrapper)) {
            return $smarty->fetch($wrapper);
        } else {
            return $contents;
        }
    }

    /**
     * получаем контроллер
     *
     * @param $controller
     * @return false|mixed
     */
    public function getPermissionByController($controller)
    {
        $controllersPermissions = $this->getControllersPermissions();

        if (!isset($controllersPermissions[$controller])) {
            return false;
        }
        return $controllersPermissions[$controller];
    }

    /**
     * получаем все контроллеры
     *
     * @return mixed
     */
    public function getControllersPermissions()
    {
        $modulesPermissions = include GLOBAL_ROOT.'/admin/config/modules.permissions.inc.php';
        $controllersPermissions = $modulesPermissions;
        foreach ($modulesPermissions as $controller => $modulePermission)  {
            $controllersPermissions[$controller] = $modulePermission;
        }

        return $controllersPermissions;
    }

    /**
     * Поиск модуля
     *
     * @param $module
     * @return int|string
     */
    public function searchModule($module)
    {
        //TODO: Доработать метод чтоб не пользоваться (modules_permissions)
        $modulesPermissions = include GLOBAL_ROOT.'/admin/config/modules.permissions.inc.php';
        foreach ( $modulesPermissions as $model => $permission ) {
            if ( is_array($permission) ) {
                foreach ( $permission as $subPermission ) {
                    if ( in_array($module, $permission) ) {
                        if ( $module === $subPermission ) {
                            return $model;
                        }
                    }
                }
            }
            if (in_array($module, $modulesPermissions)) {
                if ( $module === $permission ) {
                    return $model;
                }
            }

        }
        return 'PageError';
    }


}