<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Features;
use Mnv\Core\Managers\Role;

class FeaturesAdmin extends AdminMnv
{

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $feature = new Features();

        $this->smarty->assign('activeItem','features');
        $this->smarty->assign('title', 'Свойства товара');

        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        /** Получаемые параметры $_GET / $_POST */
        $this->action     = (string) getRequestVar('action', '');
        $this->status     = getRequestVar('status', '');

        $sectionId              = (int) getRequestVar('sectionId', '');

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $feature->featureId     = (int) getRequestVar('id', '');
        $feature->featureIds    = getRequestVar('featureIds', '', true);
        /** фильтрация статей */

        /* table list */
//        print_r($_POST);
        $this->page         = getRequestVar('start', 1, false, false);
        $this->limit        = getRequestVar('length', 20, false, false);

        $draw               = getRequestVar('draw', 1);
        $search	            = getRequestVar('search', '');     // $_POST['search']['value'];
        $columnName         = getRequestVar('columns');                 // $_POST['columns'][$columnIndex]['data'];
        $columnSortOrder    = getRequestVar('order');                   // $_POST['order'][0]['dir'];
        /* end table list */

        /** действия */
        if ($this->action == 'table') {
            $featureArr           = $feature->getTableFeatures($search['value'], $this->status, $this->page, $this->limit, $columnSortOrder, $columnName);
            $totalFeatures         = $feature->countTableFeatures($search['value'], $this->status);
            $totalFilteredFeatures = $feature->countTableFilteredFeatures($search['value']);

            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => $totalFeatures,
                "recordsFiltered"   => $totalFilteredFeatures,
                "data"              => $featureArr
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        } else if ($this->action == 'remove') {
            $feature->remove($feature->featureId);
            response()->make("deleteSuccess('" . $feature->featureId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();

        }  else if ($this->action == 'reorder') {

            $ids = array_values($feature->featureIds);
            sort($feature->featureIds);
            foreach($feature->featureIds as $i => $orderBy) {
                $feature->update($ids[$i], array('orderBy' => $orderBy));
            }

        } else if ($this->action == 'status') {

            if ($feature->status($feature->featureId)) {
                response()->json($feature->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {

            }
            exit;
        }


//        else {
////            /** получение всех статей */
////            $feature->getAll( $this->page, $this->limit, $this->query);
////
////            /** Получение кол-во статей */
////            $feature->total($this->query);
////
////            /** pagination */
////            $pages = getPageNums($feature->total, $this->page, $this->limit, 0, 4, 4, 0);
////
////            /** вывод в шаблон результатов */
////            $this->smarty->assign('totalArticles', $feature->total);
////            $this->smarty->assign('features', $feature->features);
////            $this->smarty->assign('pageNums', $pages);
////            $this->smarty->assign('limit', Session::get('limit', $this->limit));
////            $this->smarty->assign('page', $this->page);
//        }


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('features', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('features.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}