<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\FAQ;
use Mnv\Core\Managers\Role;

/**
 * Class FAQAdmin
 */
class FAQAdmin extends AdminMnv
{

	public function fetch()
    {
        $faqs = new FAQ();

        $this->smarty->assign('activeItem','faqs');
        $this->smarty->assign('title', 'FAQ');

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $faqs->faq   = (object)getRequestVar('faq', '', true);
        $faqs->faqId = getRequestVar('id', '');

        if ($this->action == 'add' || $this->action == 'edit') {
            $faqs->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($faqs->faq->question)) $this->errors['question'] = true;

            if (empty($this->errors)) {
                if (empty($faqs->faqId)) {
                    if ($faqs->add($faqs->faq)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=faq&action=edit&id=".$faqs->faqId);
                } else {
                    if ($faqs->update($faqs->faq)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }

                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=faqs");
            }
            $faqs->edit();
        }

        if (!($faqs->faq instanceof stdClass)) $faqs->faq = (object)$faqs->faq;

        $this->smarty->assign('faq', $faqs->faq);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('faqs', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('faq.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }


}