<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Currencies;
use Mnv\Core\Managers\Role;


/**
 * Class CurrencyAdmin
 */
class CurrencyAdmin extends AdminMnv
{

    public function fetch()
    {

        $currencies = new Currencies();

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));

        $currencies->currency = (object)getRequestVar('currency', '', true);
        $currencies->currencyId = (int)getRequestVar('id');

        if ($this->action == 'add' || $this->action == 'edit') {
            $currencies->edit();
        } else if ($this->action == 'save') {

            if (empty($currencies->currency->title)) $this->errors['titleNull'] = true;
            if (empty($currencies->currency->codeName)) $this->errors['codeNameNull'] = true;
            if (empty($currencies->currency->course)) $this->errors['course'] = true;

            if (empty($this->errors)) {
                if (empty($currencies->currencyId)) {
                    $currencies->add($currencies->currency);
                } else {
                    $currencies->update($currencies->currency);
                }
                // Save serializations
                if (!saveSerializations()) $this->errors['serializations'] = true;

                redirect('index.php?mod=currencies');
            }
        }

        if (!($currencies->currency instanceof stdClass)) $currencies->currency = (object)$currencies->currency;
        $this->smarty->assign('currency', $currencies->currency);

        if (!empty($errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('currencies', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('currency.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }
}


    



