<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Comments;
use Mnv\Core\Managers\Role;

/**
 * Class CommentsAdmin
 */
class CommentsAdmin extends AdminMnv
{

    protected $query;

    protected $comment;
    protected $commentId;
    protected $bulk;

    public $order;
    public $where = array();
    public $join = array();

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $comments = new Comments();

        $this->smarty->assign('activeItem','comments');
        $this->smarty->assign('title', lang('comments:title'));

        $this->comment = getRequestVar('comment','', true);
        $this->commentId = (int) getRequestVar('id','');
        $this->query   = getRequestVar('query','');
        $this->status  = getRequestVar('status','');
        $this->bulk    = getRequestVar('bulk','');

        /* statuses */
        $this->smarty->assign('statuses', lang('comments:statuses'));

        if ($this->action == 'bulk') {
            if ($comments->bulk($this->bulk)) $this->messages['bulk_save'] = true;
        }

        $this->smarty->assign('page', $this->page);

        /* показывать комментарии только из разрешенных разделов */
        $comments->getAllComments($this->query, $this->status);

        $comments->countComments($this->query, $this->status);
        $pages = getPageNums($comments->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalComments', $comments->total);
        $this->smarty->assign('comments', $comments->comments);
        $this->smarty->assign('pageNums', $pages);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('comments', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('comments.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}