<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Comments;
use Mnv\Core\Managers\Role;

/**
 * Class CommentsAdmin
 */
class CommentAdmin extends AdminMnv
{
    protected $comment;
    protected $commentId;
    protected $bulk;


    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $comments = new Comments();

        $this->smarty->assign('activeItem','comments');
        $this->smarty->assign('title', lang('comments:title'));

//        if ($this->adminManager['accessLevel'] == 'editor' && !$this->config['comments_editors_may_approve']){
//            $this->errors['access_denied'] = true;
//        }

        $this->action    = getRequestVar('action','');
        $this->comment   = getRequestVar('comment','', true);
        $this->commentId = (int) getRequestVar('id','');
        $this->bulk      = getRequestVar('bulk','');
        $this->page      = (int) getRequestVar('page','1');
        /* statuses */
        $this->smarty->assign('statuses', lang('comments:statuses'));

        if ($this->action == 'edit') {
            if (!$this->comment = $comments->edit($this->commentId))
                $this->errors['comment_not_found'] = true;

            if (empty($this->errors)) {
                $this->smarty->assign('statuses', array_slice(lang('comments:statuses'), 1));
            } else {
                $this->smarty->clearAssign('action');
            }
        } else if ($this->action == 'save') {
                $this->comment['authorName']  = trim($this->comment['authorName']);
//                $this->comment['authorEmail'] = trim($this->comment['authorEmail']);
                $this->comment['content']     = trim($this->comment['content']);

                /* checking fields */
                if (empty($this->comment['authorName'])) $this->errors['authorName'] = true;
//                if (empty($this->comment['authorEmail'])) $this->errors['authorEmail'] = true;
//                if (!empty($this->comment['authorEmail']) && !isValidEmail($this->comment['authorEmail'])) $this->errors['authorEmailNot'] = true;
                if (empty($this->comment['content'])) $this->errors['content'] = true;

                if (empty($this->errors)) {
                    if (!$comments->getComment($this->comment)) $this->errors['comment_not_found'] = true;
                    if ($comments->update($this->comment, $this->managers->manager)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                    /* if there are any errors in fields */
                    $this->smarty->assign('statuses', array_slice(lang('comments:statuses'), 1));
                    $this->smarty->assign('action', 'edit');
                }
                if (empty($this->errors)) redirect("index.php?mod=comments&page={$this->page}");


        }

        if (!($this->comment instanceof stdClass)) $this->comment = (object)$this->comment;

        $this->smarty->assign('comment', $this->comment);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('comments', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('comment.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}