<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Core\Managers\Role;
use Mnv\Models\Content;
use Mnv\Models\Contents\Exceptions\ContentNotDeletedException;
use Mnv\Models\Contents\Exceptions\EmptyArticleIdException;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotContentApproveException;

/**
 * Class ArticlesAdmin
 */
class CategorysAdmin extends AdminMnv
{

    protected $article;
    protected $articleId;
    protected $articleIds;
    protected $section;
    protected $imageId;

    protected $num;
    protected $val;

    public $query;
    public $manager;

    public $where = array();

    private $sectionIds = array();


    public function __construct()
    {
        parent::__construct();

        $this->module = getRequestVar('mod','');
        $this->smarty->assign('title', lang($this->module.':title'));
        $this->smarty->assign('activeItem', $this->module);
        /* statuses */
        $this->smarty->assign('statuses', lang('articles:statuses'));

    }


    public function fetch()
    {
        global $SECTIONS;

        $contents = new Content();
        $sectionIds = [];

        /* получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $contents->articleId  = (int) getRequestVar('id', '');
        /* фильтрация статей */
        /** фильтрация статей */
        $section       = (int) getRequestVar('section', '');
        $query         = getRequestVar('query', '');
        $status        = getRequestVar('status', '');

        $contentIds    = getRequestVar('articleIds', '', true);


        /** действия */
        if ($this->action == 'remove') {
            try {
                $contents->remove($this->managers->manager);
                $this->logger->info("Контент «" . $contents->content->title . "» удален.", $this->managers->manager);
                response()->make("deleteSuccess('" . $contents->content->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (ContentNotDeletedException $e) { /** ошибка при удаление контента */
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        } else if ($this->action == 'approve') {

            try {
                $contents->approve($this->managers->manager);
                response()->make("approveSuccess('" . $contents->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при одобрение контента */
                response()->make("approveError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'reorder') {
            $ids = array_values($contentIds);
            sort($contentIds);
            $contentIds = array_reverse($contentIds);
            $contents->reorder($ids, $contentIds);

        } else if ($this->action == 'status') {

            try {
                $contents->status();
                response()->json($contents->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        } else {

            $this->smarty->assign('page', $this->page);

            if (!empty($section) && !empty($SECTIONS[$section])) {
                $sectionIds = array($section);
                if (!empty($SECTIONS[$section]->allChildren)) {
                    $sectionIds = array_merge($sectionIds, $SECTIONS[$section]->allChildren);
                }
            }

            /** получение разделов по типу контента */
            $sections = Helpers::init()->getSectionContent(null, 'categorys');

            /* получение всех статей с картинками */
            $contents->listContent($query, $status, 'categorys', $sectionIds, 'articleId DESC', $this->managers->manager);

            if (!is_null($contents->contents)) {
                foreach ($contents->contents as $articleId => $content) {
                    $contents->contents[$articleId]->statusName = lang('general:statuses:' . $content->status);
                    $contents->contents[$articleId]->publishedOn = langDate(adjustTime($content->publishedOn, false, 'd.m.Y'));
                    $contents->contents[$articleId]->image = $contents->getFile($content->articleId);
                    $contents->contents[$articleId]->section = $SECTIONS[$content->sectionId] ?? null;
                }
            }

            /* Получение кол-во статей */
            /** Получение кол-во статей */
            $contents->total($query, $status, 'categorys', $sectionIds, $this->managers->manager);
            $pages = getPageNums($contents->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $contents->total);
            $this->smarty->assign('articles', $contents->contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);

            if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
            if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        }
//        var_dump($admin->access);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('categorys', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('categorys.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('AccessIsDenied.tpl');
        }

    }

}