<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Core\Managers\Role;

use Mnv\Models\Content;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;

/**
 * Class ArticlesAdmin
 */
class CategoryAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $content = new Content();

        $this->module = getRequestVar('mod','');

        $this->smarty->assign('title', lang($this->module.'s:title'));
        $this->smarty->assign('activeItem', $this->module.'s');

        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $content->articleId     = (int) getRequestVar('id', '');
        $content->content       = (object) getRequestVar('article', '', true);
        $date                   = getRequestVar('date', '', true);

        /** фильтрация статей */
        $query         = getRequestVar('query', '');
        $section       = (int) getRequestVar('section', '', '', true);
        $status        = getRequestVar('status', '');

        /** работа с галереей */
        $image    = getRequestVar('image', '', true);
        $gallery  = getRequestVar('gallery', '', true);
        $imageIds = getRequestVar('imageIds', '', true);
        $imageId  = (int) getRequestVar('imageId', '');
        $picture        = getRequestVar('picture', '', true);


        $sections = Helpers::init()->getSectionContent('', 'categorys');
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        $this->smarty->assign('sections', $sections);

        if (count($sections) < 2) {
            $this->errors['no_sections'] = true;
        }

        if ($this->action == 'add' || $this->action == 'edit') {

            try {
                $content->edit();
            } catch (NoContentException $e) { /** контент не найден */
                $this->errors['article_not_found'] = true;
            }
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($content->content->title)) $this->errors['title'] = true;
            $content->content->isFeatured = $content->content->isFeatured ?? 0;
            /** тип контента */
            if (empty($content->content->typeContent)) $content->content->typeContent = 'categorys';

            /** установка даты */
            $content->content->publishedOn = Helpers::init()->dateFormation($date);

            /** проверка доступных разделов для статей */
            if (empty($content->content->sectionId) || empty($sections[$content->content->sectionId])) $this->errors['sectionId'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $content->checkFileName($content->content->fileName)) {
                if ($fileName == $content->content->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->content->fileName = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $content->content->enableGallery = isset($content->content->enableGallery) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

            if (!empty($this->date['timeWeek'])) {
                $timeWeek = array();
                foreach ($this->date['timeWeek'] as $key => $val) {
                    if (!empty($val['check'])) {
                        $timeWeek[] = [
                            "day" => "true",
                            "name" => "$key",
                            "time" => [
                                "start" => $val['start'],
                                "end" => $val['end']
                            ]
                        ];
                    } else {
                        $timeWeek[] = ["day" => "false", "name" => "$key"];
                    }
                }

                $content->content->workingHours = json_encode($timeWeek);
            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $content->content->url = $SECTIONS[$content->content->sectionId]->path.'/'.$content->content->fileName.'.'.$this->config['file_extension'];

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($content->articleId)) {

                    try {
                        $content->add($content->content, $images, $this->managers->manager);
                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен контент «" . $content->content->title . "»", $this->managers->manager);

                        if (empty($this->errors) && $this->action == 'apply') {
                            redirect("index.php?mod=category&action=edit&id={$content->articleId}&page={$this->page}");
                        }
                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {
                    try {
                        $content->update($content->content, $images, $this->managers->manager);

                        $this->messages['saved'] = true;
                        $this->logger->info("Контент «" . $content->content->title . "» отредактирован", $this->managers->manager);
                    } catch (NotUpdateContentException $e) {
                        $this->errors['not_saved'] = true;

                    }
                }
            }

            if (empty($this->errors) && $this->action == 'save')  redirect("index.php?mod=categorys&page={$this->page}");

            $content->edit();

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {
            if ($content->deleteImage($content->articleId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }
        /** удаление основной картинки */
        else if ($this->action == 'editPictureInfo') {

            if ($result = $content->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        } else if ($this->action == 'sortPictures') {

            $content->sortPictures($imageIds);

        } else if ($this->action == 'deletePicture') {
            $result = $content->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('deletingImage'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingImageError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

//        switch ($this->action) {
//            case 'add':
//            case 'edit':
//            try {
//                $content->edit();
//            } catch (NoContentException $e) { /** контент не найден */
//                $this->errors['article_not_found'] = true;
//            }
//                break;
//            case 'save':
//            case 'apply':
//                /* проверка полей */
//                if (empty($this->article['title'])) $this->errors['title'] = true;
//                if (empty($this->article['typeContent'])) $this->article['typeContent'] = $this->_typeContent;
//
//                if (empty($this->article['region']))  $this->errors['region'] = true;
//
//                /** установка даты */
//                $this->article['publishedOn'] = $this->article['Year'] . '-' . $this->article['Month'] . '-' . $this->article['Day'] . ' ' . $this->article['Hour'] . ':' . $this->article['Minute'] .':00';
//                if (!empty($this->article['Meridian'])) $this->article['publishedOn'] .= " $this->article[Meridian]";
//                $this->article['publishedOn'] = date('Y-m-d H:i:s', strtotime($this->article['publishedOn']));
//
//                /** проверка доступных разделов для статей */
//                if (empty($this->article['sectionId']) || empty($sections[$this->article['sectionId']])) $this->errors['sectionId'] = true;
//                /* проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
//                if ($fileName = $content->is_file_name($this->articleId, $this->article['fileName'])) {
//                    if ($fileName == $this->article['fileName']) {
//                        $this->errors['fileNameExists'] = true;
//                    } else {
//                        $this->article['fileName'] = $fileName;
//                    }
//                }
//                if (isset($this->article['price']))  $this->article['price'] = empty($this->article['price']) ? '0.00' : $this->article['price'];
//                if (isset($this->article['oldPrice']))  $this->article['oldPrice'] = empty($this->article['oldPrice']) ? '0.00' : $this->article['oldPrice'];
//                if (isset($this->article['stock'])) $this->article['stock'] = empty($this->article['stock']) ? 0 : $this->article['stock'];
//                $this->article['enableGallery'] = isset($this->article['enableGallery']) ? 1 : 0;
//
//
//                $this->images['fileId'] = !empty($this->image) ? $this->image['fileId'] : '';
//                $this->images['gallery'] = !empty($this->gallery) ? $this->gallery : '';
//
//                if (!empty($this->date['timeWeek'])) {
//                    $timeWeek = array();
//                    foreach ($this->date['timeWeek'] as $key => $val) {
//                        if (!empty($val['check'])) {
//                            $timeWeek[] = [
//                                "day" => "true",
//                                "name" => "$key",
//                                "time" => [
//                                    "start" => $val['start'],
//                                    "end" => $val['end']
//                                ]
//                            ];
//                        } else {
//                            $timeWeek[] = ["day" => "false", "name" => "$key"];
//                        }
//                    }
//
//                    $this->article['workingHours'] = json_encode($timeWeek);
//                }
//
////                print_r($this->article);
//                /* если ошибок нет то можно продолжить дальше */
//                if (empty($this->errors)) {
//                    /* построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
//                    $this->article['url'] = $SECTIONS[$this->article['sectionId']]->path.'/'.$this->article['fileName'].'.'.$this->config['file_extension'];
//
//                    /* если пустой ID то создаем новую статью / если существует ID то редактируем статью */
//                    if (empty($this->articleId)) {
//                        if ($this->articleId = $content->newContent($this->article, $this->images)) {
//                            $this->messages['saved'] = true;
//                            $this->logger->info("Добавлена новая статья «" . $this->article->title . "»");
//                            if (empty($this->errors) && $this->action == 'apply') {
//	                            if (!empty($this->manager)) {
//					            	redirect("index.php?mod=".$this->module."&action=edit&id={$this->articleId}&page={$this->page}&manager={$this->manager}");
//				            	} else {
//					            	redirect("index.php?mod=".$this->module."&action=edit&id={$this->articleId}&page={$this->page}");
//				            	}
//
//	                        }
//                        } else {
//                            $this->errors['not_saved'] = true;
//                        }
//                    } else {
//                        if ($this->article = $content->updateContent($this->articleId, $this->article, $this->images)) {
//                            $this->messages['saved'] = true;
//                            $this->logger->info("Статья «" . $this->article->title . "» отредактирована");
//                        } else {
//                            $this->errors['not_saved'] = true;
//                        }
//                    }
//                    $objects = $content->getAllObjects();
//                    $this->createJson($objects);
//                    // TODO: загрузка объектов в json файл
//                } else {
//
//                    /* если есть какие-либо ошибки в полях */
//                    $this->smarty->assign('statuses', array_slice(lang('articles:statuses'), 1));
//                    $this->article = arrStripSlashes($this->article);
//                    $this->smarty->assign('action', 'edit');
//                }
//
//                if (empty($this->errors) && $this->action == 'save') {
//	            	if (!empty($this->manager)) {
//		            	redirect("index.php?mod=".$this->module."s&page={$this->page}&manager={$this->manager}");
//	            	} else {
//		            	redirect("index.php?mod=".$this->module."s&page={$this->page}");
//	            	}
//
//	            }
//                break;
//            case 'deleteImage':
//                if ($content->delete_image($this->articleId)) {
//                    echo "document.getElementById('image_general').style.display='none';";
//                    echo "deleteImageMessage();";
//                    exit;
//                }
//                break;
//            case 'editPictureInfo':
//                if ($image = $content->edit_picture_info($this->imageId, $this->imageAlt, $this->imageLink)) {
//                    $result = array('data' => true, 'alt'=>$image['alt'], 'link'=>$image['link']);
//                } else {
//                    $result = array('data' => false);
//                }
//                jsonResponse($result);
//                break;
//            case 'sortPictures':
//                $content->sort_pictures($this->imageIds);
//                break;
//            case 'deletePicture':
//                if ($content->delete_picture($this->imageId)){
//                    $result = array('del' => true);
//                } else {
//                    $result = array('del' => false);
//                }
//                jsonResponse($result);
//                break;
//        }


        if (!($content->content instanceof \stdClass)) $content->content = (object)$content->content;

//print_r($content->content);
        $this->smarty->assign('article', $content->content);
        $this->smarty->assign('date', $date);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [\Mnv\Core\Managers\Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('categorys', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('category.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('AccessIsDenied.tpl');
        }
//        return $this->smarty->fetch($this->module.'.tpl');

    }


}