<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Brands;
use Mnv\Core\Managers\Role;

/**
 * Class ArticlesAdmin
 */
class BrandsAdmin extends AdminMnv
{

    private $draw;
    private $start;
    private $length;
    private $search;
    private $searchValue;
    private $columnName;
    private $columnSortOrder;

    /**
     * Вывод всех статей
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $brands = new Brands();

        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');

        $brands->brandId     = (int) getRequestVar('id', '');

        /** table list */
        $this->draw             = (int)getRequestVar('draw', 1);
        $this->start            = (int)getRequestVar('start', 0);
        $this->length           = (int)getRequestVar('length', 10);
        $this->search	        = getRequestVar('search', '');
        $this->searchValue      = getRequestVar('search'); //$_POST['search']['value'];
        $this->columnName       = getRequestVar('columns'); //$_POST['columns'][$columnIndex]['data'];
        $this->columnSortOrder  = getRequestVar('order');// $_POST['order'][0]['dir'];
        /* end table list */

        if ($this->action == 'read_table') {

            $brandsArr = $brands->getTableBrands($this->start, $this->length, $this->searchValue, $this->columnSortOrder, $this->columnName);
            $totalBrands = $brands->countTableBrands();
            $totalFilteredBrands = $brands->countTableFilteredBrands($this->searchValue);

            $response = array(
                "draw"              => intval($this->draw),
                "recordsTotal"      => $totalBrands,
                "recordsFiltered"   => $totalFilteredBrands,
                "data"              => $brandsArr
            );
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

        } else if ($this->action == 'remove') {

            if ($brands->removeBrand()) {
                $this->logger->info("Бранд с «ID-" . $brands->brandId . "» удален.", $this->managers->manager);
                response()->make("deleteSuccess('" . $brands->brandId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else if ($this->action == 'approve') {

            if ($brands->approveBrand()) {
                response()->make("document.getElementById('status-$brands->brandId ').innerHTML = 'Включено';", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        }
        // не делал еще
//        else if ($this->action == 'reorder') {
//
//            $ids = array_values($this->brandIds);
//            sort($this->brandIds);
//            //$this->brandIds = array_reverse($this->brandIds);
//            $brands->reorderBrand($ids, $this->brandIds);
//
//        }
        else if ($this->action == 'status') {

            if ($result = $brands->statusBrand()) {
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            }

        }

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('brands', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('brands.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }

}