<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\BannerGroups;

/**
 * Class BannerGroupAdmin
 */
class BannerGroupAdmin extends AdminMnv
{

	public function fetch()
    {
        $groupBanners = new BannerGroups();

        $this->smarty->assign('activeItem','bannergroups');
        $this->smarty->assign('title', 'Группы баннеров');

        $this->smarty->assign('statuses', array_slice(lang('sliders:statuses'), 1));
        $this->smarty->assign('sections', Helpers::init()->getAllSectionOptions());

        $groupBanners->group   = (object)getRequestVar('group', '',  true);
        $groupBanners->groupId = (int) getRequestVar('id', '');

        if ($this->action == 'add' || $this->action == 'edit') {

            $groupBanners->edit();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($groupBanners->group->name)) $this->errors['name'] = true;
            $groupBanners->group->pages = implode(',',  $groupBanners->group->pages);

            if (empty($this->errors)) {
                if (empty($groupBanners->groupId)) {
                    if ($groupBanners->add($groupBanners->group)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=bannergroup&action=edit&id=".$groupBanners->groupId);
                } else {
                    if ($groupBanners->update($groupBanners->group)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }
                $groupBanners->edit();

                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=bannergroups");
            }
        }

        if (!($groupBanners->group instanceof \stdClass)) $groupBanners->group = (object)$groupBanners->group;

        $this->smarty->assign('group',  $groupBanners->group);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('bannergroups', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('banner-group.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }


}