<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Models\Banners;
use Mnv\Core\Managers\Role;

/**
 * Class BannersAdmin
 */
class BannerAdmin extends AdminMnv
{

    protected $banner;
    protected $bannerId;


    /**
     * Вывод всех банеров
     *
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {

        $banners = new Banners();

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', lang('banners:sectionName'));

        $this->action   = getRequestVar('action','');
        $this->banner   = getRequestVar('banner','', true);
        $this->bannerId = getRequestVar('id','');

        $lang     = getRequestVar('SITE_LANG','');

        if (empty($lang)) $lang;

        switch ($this->action) {
            case 'add':
            case 'edit':
                $this->banner = $banners->editBanner($this->bannerId);
                break;
            case 'save':

                $this->banner['lang'] = $lang;
                if (empty($this->banner['isActive'])) $this->banner['isActive'] = 0;

                if (is_file($_FILES['file']['tmp_name'])) {
                    $uploadedFile = getimagesize($_FILES['file']['tmp_name']);
                    if ($uploadedFile[2] != 1 AND $uploadedFile[2] != 2 AND $uploadedFile[2] != 3 AND $uploadedFile[2] != 4  AND $uploadedFile[2] != 13) $this->errors['fileType'] = true;
                    $fileSrc = $_FILES['file'];
                }

                if (empty($this->banner['bannerName'])) $this->errors['bannerName'] = true;

                if (empty($this->errors)) {

                    if (!empty($fileSrc)) {
                        $this->banner['bannerWidth'] 	= $uploadedFile[0];
                        $this->banner['bannerHeight'] 	= $uploadedFile[1];
                        $this->banner['bannerType']		= $uploadedFile[2];

                        if (!is_dir(SITE_ROOT . '/uploads/bs')) mkdir(SITE_ROOT . '/uploads/bs', 0777);
                        /* Deleting old banner file */
                        if ($this->banner['fileUrl']) @unlinkFile(SITE_ROOT . '/' . $this->banner['fileUrl']);

                        $fileExtension = explode("." , $_FILES['file']['name']);
                        $fileExtension = $fileExtension[sizeof($fileExtension)-1];
                        $this->banner['fileUrl'] = 'uploads/bs/bs-' . substr(md5($_FILES['file']['name'] . time()) , 3, 6) . '.' . $fileExtension;
                        move_uploaded_file($_FILES['file']['tmp_name'], SITE_ROOT . '/' . $this->banner['fileUrl']);
                        chmod(SITE_ROOT	 . '/' . $this->banner['fileUrl'], 0755);
                    }

                    $this->smarty->assignByRef('banner', $this->banner);
                    $this->banner['generatedCode'] = $this->smarty->fetch('generate-banner-code.tpl');

                    if (empty($this->banner['bannerId'])) {
                        if ($this->banner['bannerId'] = $banners->newBanner($this->banner)) {
                            $this->messages['saved'] = true;
                        }  else {
                            $this->errors['not_saved'] = true;
                        }
                    } else {
                        if ($banners->updateBanner($this->banner)) {
                            $this->messages['saved'] = true;
                        } else {
                            $this->errors['not_saved'] = true;
                        }
                    }
                } else {
                    $this->smarty->assign('action','edit');
                }

                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=banners");

                break;
            case 'generateCode':
                $this->banner['frame'] = $this->smarty->fetch('banners-output.tpl');
                break;
        }

        $this->smarty->assign('banner', $this->banner);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('banners', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('banners.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }
}


